/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.configuration.IConfigurationWithInputFileList;
import com.biotechvana.workflow.configuration.SimpleWorkflowConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import java.util.ArrayList;
import java.util.List;

public class InputProcessingWorkflowConfiguration
extends SimpleWorkflowConfiguration
implements IConfigurationWithInputFileList {
    protected boolean isPairEnd;
    protected String fileFormat = "";
    protected ArrayList<String> inputFiles = new ArrayList();
    protected ArrayList<String> inputFiles1 = new ArrayList();
    protected ArrayList<String> inputFiles2 = new ArrayList();
    protected ArrayList<String> library = new ArrayList();

    public InputProcessingWorkflowConfiguration(IWorkflowManager workflowManager) {
        super(workflowManager);
    }

    public void setIsPaired(boolean isPaired) {
        this.isPairEnd = isPaired;
    }

    public boolean isPairEnd() {
        return this.isPairEnd;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setAllInputFiles(String[] list) {
        this.inputFiles.clear();
        this.inputFiles1.clear();
        this.inputFiles2.clear();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.inputFiles.add(item);
            ++n2;
        }
    }

    public void setLibrary(String[] list) {
        this.library.clear();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.library.add(item);
            ++n2;
        }
    }

    public void setInputFiles(String[] firstList, String[] ... otherLists) {
        String item;
        this.inputFiles.clear();
        this.inputFiles1.clear();
        this.inputFiles2.clear();
        String[] stringArray = firstList;
        int n = firstList.length;
        int n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            this.inputFiles.add(item);
            this.inputFiles1.add(item);
            ++n2;
        }
        if (otherLists != null && otherLists.length != 0) {
            stringArray = otherLists[0];
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                item = stringArray[n2];
                this.inputFiles.add(item);
                this.inputFiles2.add(item);
                ++n2;
            }
        }
    }

    public ArrayList<String> getInputFiles() {
        return this.inputFiles;
    }

    public ArrayList<String> getInputFiles1() {
        if (!this.inputFiles1.isEmpty()) {
            return this.inputFiles1;
        }
        return this.inputFiles1;
    }

    public ArrayList<String> getInputFiles2() {
        if (!this.inputFiles2.isEmpty()) {
            return this.inputFiles2;
        }
        return this.inputFiles2;
    }

    public IValidationResult validate() {
        IValidationResult res = super.validate();
        if (!res.isOK()) {
            return res;
        }
        String errMsg = "";
        if (errMsg.isEmpty()) {
            if (this.inputFiles.isEmpty()) {
                errMsg = "No Input Files have been provided. Please select Files from your FTP Account.";
            } else if (this.isPairEnd && this.inputFiles1.size() != this.inputFiles2.size()) {
                errMsg = "Input File lists do not have the same number of files.";
            }
        }
        if (!errMsg.isEmpty()) {
            return new ValidationResult(4, -1, errMsg);
        }
        return res;
    }

    public IValidationResult feedWorkflow() {
        IValidationResult validation = super.feedWorkflow();
        if (!validation.isOK()) {
            return validation;
        }
        String inputVarValue = "";
        String librarynames = "";
        int i = 0;
        while (i < this.library.size()) {
            inputVarValue = this.isPairEnd() ? String.valueOf(inputVarValue) + this.inputFiles1.get(i) + "," + this.inputFiles2.get(i) + "\n" : String.valueOf(inputVarValue) + this.inputFiles1.get(i) + "\n";
            librarynames = String.valueOf(librarynames) + this.library.get(i) + "\n";
            ++i;
        }
        WorkflowStartupJob startJob = this.pipeline.getStartupJob();
        startJob.setValue("INPUT_FILES", inputVarValue);
        startJob.setValue("INPUT_LIBRARY_NAMES", librarynames);
        return validation;
    }

    protected void onSettingWorkflow() {
        super.onSettingWorkflow();
        this.isPairEnd = this.pipeline.getMetadata().hasTag("pairend");
    }

    public List<String> getLibrary() {
        return this.library;
    }
}

