/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		May 5, 2011
 * 
 * @license		<a href="http://creativecommons.org/licenses/by-nc-sa/3.0/">
 * 				Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>
 *
 * @copyright	Copyright Biotech Vana, S.L. 2006-2011
 */
package com.biotechvana.javabiotoolkit.io;

import java.io.FileNotFoundException;
import java.io.IOException;

import com.biotechvana.javabiotoolkit.DNASequence;
import com.biotechvana.javabiotoolkit.exceptions.InvalidSequenceCharacterException;
import com.biotechvana.javabiotoolkit.exceptions.SequenceTooLongException;

/**
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 * @version	0.1
 *
 */
public interface IContigProvider
{
	public static final int I_componentLength = 100*1000; // 1 Megabase
	
	/**
	 * 
	 * @param	ignoreInvalidCharacters
	 * @param	index
	 * @return
	 * @throws	SequenceTooLongException
	 * @throws	InvalidSequenceCharacterException
	 * @throws	FileNotFoundException
	 * @throws	IOException
	 *
	 * @since	0.1
	 */
	public DNASequence loadDnaComponent(boolean ignoreInvalidCharacters, int index)
	throws SequenceTooLongException, InvalidSequenceCharacterException, FileNotFoundException, IOException;
	
	/**
	 * 
	 * @param	index
	 * @return
	 * @throws	SequenceTooLongException
	 * @throws	InvalidSequenceCharacterException
	 * @throws	FileNotFoundException
	 * @throws	IOException
	 *
	 * @since	0.1
	 */
	public DNASequence loadDnaComponent(int index)
	throws SequenceTooLongException, InvalidSequenceCharacterException, FileNotFoundException, IOException;
	
	/**
	 * 
	 * @return
	 *
	 * @since	0.1
	 */
	public int getNumberOfComponents();
	
	/**
	 * 
	 * @return
	 *
	 * @since	0.1
	 */
	public int contigLength();
}
