/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2010-09-01
 * 
 * @license		See <a href="http://www.biotechvana.com></a>
 *
 * @copyright	Copyright Biotech Vana, S.L. 2006-2010
 */

package com.biotechvana.javabiotoolkit.exceptions;

/**
 * Exception thrown to indicate that a method in BSJT does not support this (subclass) instance of 
 * <code>BioSequence</code>. This exception is subject to disappear in the future, when all operations can handle 
 * correctly all sequence types. 
 * 
 * @version	1.1, 2010-11-01
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 */
public class UnknownSequenceClassException 
extends Exception
{
	/**
	 * Auto-generated by Eclipse.
	 */
	private static final long serialVersionUID = -5379591274840324503L;

	/**
	 * Default constructor with no arguments.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public UnknownSequenceClassException()
	{
		super();
	}
	
	/**
	 * Default constructor with <code>String</code> argument.
	 * 
	 * @param	message	the detail message.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public UnknownSequenceClassException(String message)
	{
		super(message);
	}
}
