 
package com.biotechvana.netools.ui.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

import com.biotechvana.netools.ui.UIConstants;

import org.eclipse.e4.core.di.annotations.CanExecute;

public class WorkspacePersepective {
	@Execute
	public void execute(MApplication app, EPartService partService, 
		      EModelService modelService) {
		 MPerspective element = 
			        (MPerspective) modelService.find(UIConstants.NETOOLS_PERSPECTIVE_DEFAULT, app);
			    // now switch perspective
		 if (element != null) {
			 partService.switchPerspective(element);
		 }
			   
	}
	
	
	@CanExecute
	public boolean canExecute(EModelService modelService,MWindow window) {
		MPerspective p =  modelService.getActivePerspective(window);
		if (p == null) {
			return false;
		}
		return !UIConstants.NETOOLS_PERSPECTIVE_DEFAULT.equals(p.getElementId());
	}
		
}