package com.biotechvana.netools.ui.handlers;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.ui.UIConstants;
import com.biotechvana.netools.ui.dialogs.NewProjectDialog;

import jakarta.inject.Named;


public class ProjectViewPrespective {

	
	@Execute
	public void execute(MApplication app, EPartService partService, 
		      EModelService modelService,
		      @Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
              @Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
              IProjectsManager projectsManager,
              IEclipseContext context) {
		 // Get the workbench context
		 IEclipseContext workbenchContext = app.getContext();

		// check if we have a project, if not create one and add it to the context
		// Check if we have an active project, if not create one and add it to the context
        if (activeProject == null) {
//            NewProjectDialog dialog = new NewProjectDialog(activeShell);
//            if (dialog.open() == NewProjectDialog.OK) {
//                String projectName = dialog.getProjectName();
//                String projectDescription = dialog.getProjectDescription();
//
//                activeProject = new Project(projectName, projectDescription);
//                projectsManager.createProject(activeProject);
//
//                // Add the new project to the context
//                workbenchContext.set(IProjectsManager.ACTIVE_PROJECT, activeProject);
//            }
        	activeProject = projectsManager.getActiveProject();
        	workbenchContext.set(IProjectsManager.ACTIVE_PROJECT, activeProject);
        }
		
		
		
		 MPerspective element = 
			        (MPerspective) modelService.find(UIConstants.NETOOLS_PERSPECTIVE_PROJECTS, app);
			    // now switch perspective
			    partService.switchPerspective(element);
	}
	@CanExecute
	public boolean canExecute(EModelService modelService,MWindow window) {
		MPerspective p =  modelService.getActivePerspective(window);
		if (p == null) {
			return false;
		}
		return !UIConstants.NETOOLS_PERSPECTIVE_PROJECTS.equals(p.getElementId());
	}
}
