package com.biotechvana.netools.ui.dialogs;


import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;

import org.eclipse.swt.widgets.Label;

public class NewProjectDialog extends TitleAreaDialog {

    private Text projectNameText;
    private Text projectDescriptionText;
    private String projectName;
    private String projectDescription;
    private Project project;
    private String errorMessage;
	private IProjectsManager projectsManager;

    public NewProjectDialog(Shell parentShell) {
        super(parentShell);
    }

    public NewProjectDialog(Shell parentShell,IProjectsManager projectsManager,    Project project, String errorMessage) {
        super(parentShell);
        this.project = project;
        this.errorMessage = errorMessage;
    }

    public NewProjectDialog(Shell shell, IProjectsManager projectsManager) {
		super(shell);
		this.projectsManager = projectsManager;
	}

	@Override
    public void create() {
        super.create();
        setTitle("New Project");
        setMessage("Enter the details for the new project");
        if (errorMessage != null) {
            setErrorMessage(errorMessage);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite) super.createDialogArea(parent);
        Composite container = new Composite(area, SWT.NONE);
        container.setLayoutData(new GridData(GridData.FILL_BOTH));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout(layout);

        createProjectNameField(container);
        createProjectDescriptionField(container);

        if (project != null) {
            projectNameText.setText(project.getProjectName());
            projectDescriptionText.setText(project.getProjectDescription());
        }

        return area;
    }

    private void createProjectNameField(Composite container) {
        Label lblProjectName = new Label(container, SWT.NONE);
        lblProjectName.setText("Project Name:");

        GridData dataProjectName = new GridData();
        dataProjectName.grabExcessHorizontalSpace = true;
        dataProjectName.horizontalAlignment = GridData.FILL;

        projectNameText = new Text(container, SWT.BORDER);
        projectNameText.setLayoutData(dataProjectName);
    }

    private void createProjectDescriptionField(Composite container) {
        Label lblProjectDescription = new Label(container, SWT.NONE);
        lblProjectDescription.setText("Project Description:");

        GridData dataProjectDescription = new GridData();
        dataProjectDescription.grabExcessHorizontalSpace = true;
        dataProjectDescription.horizontalAlignment = GridData.FILL;

        projectDescriptionText = new Text(container, SWT.BORDER);
        projectDescriptionText.setLayoutData(dataProjectDescription);
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void okPressed() {
        projectName = projectNameText.getText();
        projectDescription = projectDescriptionText.getText();
        if (validate() ) {
        	if (project == null) {
                project = new Project(projectName, projectDescription);
            }
        	project.setProjectName(projectName);
            project.setProjectDescription(projectDescription);
            super.okPressed();
        }
        
    }

    private boolean validate() {
		// TODO Auto-generated method stub
		if (projectName == null || projectName.isEmpty()) {
			setErrorMessage("Project Name cannot be empty");
			return false;
		}
		// check if the project name is unique
		if (projectsManager.getProjectEntries().stream().anyMatch(p -> p.getProjectName().equals(projectName))) {
			setErrorMessage("Project Name already exists");
			return false;
		}
		return true;
	}

	public String getProjectName() {
        return projectName;
    }

    public String getProjectDescription() {
        return projectDescription;
    }

    public Project getProject() {
        return project;
    }
}