package com.biotechvana.netools.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.netools.projects.BNLearnNetworkBuild;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkBuild;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.jobs.NetworkBuildJob;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.WorkflowValidationSet;

public class NetworkBuildDialog extends TitleAreaDialog {
	

	Project activeProject;
	private BNLearnNetworkBuild bnLearnNetworkBuild;

	private boolean isFormValid = true;
	private boolean isNetworkNameValid = true;
	private boolean isNBootstrapValid = true;
	private boolean isBootstrapScoreThresholdValid = true;
	private boolean isBicScoreThresholdValid = true;
	private boolean isPValueThresholdValid = true;
	
	private boolean isMaxParentsValid = true;
	
	public NetworkBuildDialog(Shell parentShell, Project activeProject) {
		super(parentShell);
		this.activeProject = activeProject;
		
	}
	@Override
    public void create() {
        super.create();
        setTitle("Structure Learning build");
        setMessage("Enter the details for the new network structure build");
    }
	Composite container;
    @Override
    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite) super.createDialogArea(parent);
        container = new Composite(area, SWT.NONE);
        container.setLayoutData(new GridData(GridData.FILL_BOTH));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout(layout);

        createParameters(container);

        return area;
    }
    Text networkNameText;
    ControlDecoration networkNameDecoration;
    
	private void createParameters(Composite container) {
		
			bnLearnNetworkBuild = new BNLearnNetworkBuild();

			GridData gd = new GridData(SWT.FILL, SWT.FILL, false, false);
			gd.widthHint = 200;
			gd.horizontalIndent = 10;

			// Create the widgets
			Label networkNameLabel =  new Label(container, SWT.NONE);
			networkNameLabel.setLayoutData(gd);
			networkNameLabel.setText("Network Name:");
			networkNameText = new Text(container, SWT.BORDER);
			networkNameText.setToolTipText("Set a unique name for the network structure build process. Unique names are required to be able to distinguish between different network structures.");
			networkNameText.setLayoutData(gd);
			if (bnLearnNetworkBuild.getNetworkName() != null)
				networkNameText.setText(bnLearnNetworkBuild.getNetworkName());
			else 
				networkNameText.setText("");
			networkNameDecoration = new ControlDecoration(networkNameText, SWT.TOP | SWT.LEFT);
			networkNameDecoration.setDescriptionText("Network name cannot be empty and must contain only letters or underscores.");
			networkNameDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
			networkNameDecoration.hide();

			networkNameText.addModifyListener(e -> {
				String networkName = networkNameText.getText();
				// validate network name is not empty and contains only letters, numbers or underscores
				if (networkName.isEmpty() || !networkName.matches("[a-zA-Z0-9_]+")) {
					networkNameDecoration.show();
					isNetworkNameValid = false;
				} else {
					networkNameDecoration.hide();
					isNetworkNameValid = true;
				}
				bnLearnNetworkBuild.setNetworkName(networkName);
				validateForm();
			});


			Label scoreLabel =  new Label(container, SWT.NONE);
			
			scoreLabel.setLayoutData(gd);
			scoreLabel.setText("Score:");
			Combo scoreCombo = new Combo(container, SWT.DROP_DOWN | SWT.READ_ONLY);
			scoreCombo.setLayoutData(gd);
			scoreCombo.setItems(new String[] { "AIC", "BIC", "Loglik" });
			scoreCombo.setToolTipText("Select the scoring method to be used for the network structure learning process.");
			scoreCombo.select(1); // Default to BIC
			scoreCombo.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					bnLearnNetworkBuild.setScore(com.biotechvana.netools.projects.NetworkBuild.NetworkScore.valueOf(scoreCombo.getText()));
				}
			});

			
			
			
			
			
			

//			Label maxParentLabel = new Label(container, SWT.NONE);
//			maxParentLabel.setLayoutData(gd);
//			maxParentLabel.setText("Max Parents:");
//			Text maxParentsText = new Text(container,  SWT.BORDER);
//			maxParentsText.setText(String.valueOf(bnLearnNetworkBuild.getMaxParents()));
//			maxParentsText.setLayoutData(gd);
//			ControlDecoration maxParentsDecoration = new ControlDecoration(maxParentsText, SWT.TOP | SWT.LEFT);
//			maxParentsDecoration.setDescriptionText("Please enter a valid integer.");
//			maxParentsDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
//			maxParentsDecoration.hide();
//
//			maxParentsText.addModifyListener(e -> {
//				try {
//					int maxParents = Integer.parseInt(maxParentsText.getText());
//					bnLearnNetworkBuild.setMaxParents(maxParents);
//					maxParentsDecoration.hide();
//					isMaxParentsValid = true;
//				} catch (NumberFormatException ex) {
//					maxParentsDecoration.show();
//					isMaxParentsValid = false;
//				}
//				validateForm();
//			});

			
//			Button bootstrapButton = new Button(container, SWT.CHECK);
//			bootstrapButton.setText("Use Bootstrap");
//			gd = new GridData(SWT.FILL, SWT.FILL, false, false);
//			gd.widthHint = 200;
//			gd.horizontalIndent = 10;
//			gd.verticalIndent = 10;
//			bootstrapButton.setLayoutData(gd);
//			bootstrapButton.setSelection(bnLearnNetworkBuild.isBootstrap());
			
			Label useBootstrap = new Label(container, SWT.NONE);
			gd = new GridData(SWT.FILL, SWT.FILL, false, false);
			useBootstrap.setLayoutData(gd);
			useBootstrap.setText("#N Bootstrap instances");
			


//			Label nBootstrapLabel = new Label(container, SWT.NONE);
//			nBootstrapLabel.setLayoutData(gd);
			Text nBootstrapText = new Text(container, SWT.BORDER);
			nBootstrapText.setText(String.valueOf(bnLearnNetworkBuild.getNBootstrap()));
			nBootstrapText.setToolTipText("Set the number of bootstrap replica to be used for the network structure learning process.");
			gd = new GridData(SWT.FILL, SWT.FILL, false, false);
			gd.widthHint = 200;
			gd.horizontalIndent = 10;
			gd.verticalIndent = 10;
			nBootstrapText.setLayoutData(gd);
			ControlDecoration nBootstrapDecoration = new ControlDecoration(nBootstrapText, SWT.TOP | SWT.LEFT);
			nBootstrapDecoration.setDescriptionText("Please enter a valid number.");
			nBootstrapDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
			nBootstrapDecoration.hide();

			nBootstrapText.addModifyListener(e -> {
				try {
					//if(bootstrapButton.getSelection()) { 
						int nBootstrap = Integer.parseInt(nBootstrapText.getText());
						bnLearnNetworkBuild.setNBootstrap(nBootstrap);
						nBootstrapDecoration.hide();
						isNBootstrapValid = true;
					//} 
					
					
					
				} catch (NumberFormatException ex) {
					nBootstrapDecoration.show();
					isNBootstrapValid = false;
				}
				validateForm();
			});


//			bootstrapButton.addSelectionListener(new SelectionAdapter() {
//				@Override
//				public void widgetSelected(SelectionEvent e) {
//					boolean isSelected = bootstrapButton.getSelection();
//					bnLearnNetworkBuild.setBootstrap(isSelected);
//					nBootstrapText.setEnabled(isSelected);
//					bootstrapScoreThresholdText.setEnabled(isSelected);
//					if (!isSelected) {
//						nBootstrapText.setText("");
//						isNBootstrapValid = true;
//					} else {
//						nBootstrapText.setText(String.valueOf(bnLearnNetworkBuild.getNBootstrap()));
//						bootstrapScoreThresholdText.setText(String.valueOf(bnLearnNetworkBuild.getBootstrapScoreThreshold()));
//					}
//					validateForm();
//				}
//			});

			nBootstrapText.setEnabled(bnLearnNetworkBuild.isBootstrap());
			
			
			
			
			Button runModelSelectionButton = new Button(container, SWT.CHECK);
			runModelSelectionButton.setText("Run Model and Network Selection");
			runModelSelectionButton.setToolTipText("Select this option to run the model and network selection process using the following threshold filters.");
			gd = new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1);
			gd.horizontalIndent = 10;
			runModelSelectionButton.setLayoutData(gd);
			runModelSelectionButton.setSelection(bnLearnNetworkBuild.getRunModelSelection());
			
			
			Group modelGroup = new Group(container, SWT.NONE);
			modelGroup.setText("Model && Network selection");
			modelGroup.setLayout(new GridLayout(2, false));	
			modelGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
			createModelGroup(modelGroup);
			
			
			runModelSelectionButton.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					boolean isSelected = runModelSelectionButton.getSelection();
					
					boolean isBootstrap = true ;// bootstrapButton.getSelection();
					
					if (isSelected && !isBootstrap) {
						bootstrapScoreThresholdText.setEnabled(false);
					}
					else {
						bootstrapScoreThresholdText.setEnabled(isSelected);
					}
					adaptiveBootstrapScoreSelectionButton.setEnabled(isSelected);
					bicScoreThresholdText.setEnabled(isSelected);
					pValueThresholdText.setEnabled(isSelected);
					
					
					bnLearnNetworkBuild.setRunModelSelection(isSelected);
					validateForm();
				}
			});
			
			
	}
	
	Button adaptiveBootstrapScoreSelectionButton ;
	Text bootstrapScoreThresholdText;
	Text bicScoreThresholdText;
	Text pValueThresholdText;
	private void createModelGroup(Group modelGroup) {
		
		GridData gd = new GridData(SWT.FILL, SWT.FILL, false, false,2,1);
		gd.widthHint = 200;
		gd.horizontalIndent = 10;
		
		adaptiveBootstrapScoreSelectionButton = new Button(modelGroup, SWT.CHECK);
		adaptiveBootstrapScoreSelectionButton.setText("Adaptive Bootstrap Score Selection");
		adaptiveBootstrapScoreSelectionButton.setToolTipText("Select this option to run the adaptive bootstrap score selection process. You don't need to provide the bootstrap score threshold.");
		adaptiveBootstrapScoreSelectionButton.setLayoutData(gd);
		adaptiveBootstrapScoreSelectionButton.setSelection(bnLearnNetworkBuild.getUseAdaptiveBootstrapScoreSelection());
		
		
		 gd = new GridData(SWT.FILL, SWT.FILL, false, false);
			gd.widthHint = 200;
			gd.horizontalIndent = 10;
		Label scoreThLabel = new Label(modelGroup, SWT.NONE);
		scoreThLabel.setLayoutData(gd);
		scoreThLabel.setText("Bootstrap Score Threshold:");
		bootstrapScoreThresholdText =new Text(modelGroup,  SWT.BORDER);
		
		
		if(!bnLearnNetworkBuild.getUseAdaptiveBootstrapScoreSelection())
			bootstrapScoreThresholdText.setText(String.valueOf(bnLearnNetworkBuild.getBootstrapScoreThreshold()));
		else
			bootstrapScoreThresholdText.setText("");
		bootstrapScoreThresholdText.setLayoutData(gd);
		ControlDecoration scoreThresholdDecoration = new ControlDecoration(bootstrapScoreThresholdText, SWT.TOP | SWT.LEFT);
		scoreThresholdDecoration.setDescriptionText("Please enter a valid double value.");
		scoreThresholdDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
		scoreThresholdDecoration.hide();

		bootstrapScoreThresholdText.addModifyListener(e -> {
			try {
				if (bnLearnNetworkBuild.getUseAdaptiveBootstrapScoreSelection()  || !bnLearnNetworkBuild.getRunModelSelection()) {
					isBootstrapScoreThresholdValid = true;
					return;
				} 
				double scoreThreshold = Double.parseDouble(bootstrapScoreThresholdText.getText());
				bnLearnNetworkBuild.setScoreThreshold(scoreThreshold);
				scoreThresholdDecoration.hide();
				isBootstrapScoreThresholdValid = true;
			} catch (NumberFormatException ex) {
				scoreThresholdDecoration.show();
				isBootstrapScoreThresholdValid = false;
			}
			validateForm();
		});
		
		
		Label bicScoreThLabel = new Label(modelGroup, SWT.NONE);
		bicScoreThLabel.setLayoutData(gd);
		bicScoreThLabel.setText("BIC Score Threshold:");
		bicScoreThresholdText = new Text(modelGroup, SWT.BORDER);
		bicScoreThresholdText.setText(String.valueOf(bnLearnNetworkBuild.getBicScoreThreshold()));
		bicScoreThresholdText.setLayoutData(gd);
		ControlDecoration bicScoreThresholdDecoration = new ControlDecoration(bicScoreThresholdText, SWT.TOP | SWT.LEFT);
		bicScoreThresholdDecoration.setDescriptionText("Please enter a valid double value.");
		bicScoreThresholdDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
		bicScoreThresholdDecoration.hide();
		
		bicScoreThresholdText.addModifyListener(e -> {
			try {
				double bicScoreThreshold = Double.parseDouble(bicScoreThresholdText.getText());
				bnLearnNetworkBuild.setBicScoreThreshold(bicScoreThreshold);
				bicScoreThresholdDecoration.hide();
				isBootstrapScoreThresholdValid = true;
			} catch (NumberFormatException ex) {
				bicScoreThresholdDecoration.show();
				isBootstrapScoreThresholdValid = false;
			}
			validateForm();
		});
		
		
		Label pValueLabel = new Label(modelGroup, SWT.NONE);
		pValueLabel.setLayoutData(gd);
		pValueLabel.setText("P-Value Threshold:");
		pValueThresholdText = new Text(modelGroup, SWT.BORDER);
		pValueThresholdText.setText(String.valueOf(bnLearnNetworkBuild.getPValueThreshold()));
		pValueThresholdText.setLayoutData(gd);
		ControlDecoration pValueThresholdDecoration = new ControlDecoration(pValueThresholdText, SWT.TOP | SWT.LEFT);
		pValueThresholdDecoration.setDescriptionText("Please enter a valid double value.");
		pValueThresholdDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR).getImage());
		pValueThresholdDecoration.hide();
		
		pValueThresholdText.addModifyListener(e -> {
			try {
				
				
				
				double pValueThreshold = Double.parseDouble(pValueThresholdText.getText());
				bnLearnNetworkBuild.setPValueThreshold(pValueThreshold);
				pValueThresholdDecoration.hide();
				isBootstrapScoreThresholdValid = true;
			} catch (NumberFormatException ex) {
				pValueThresholdDecoration.show();
				isBootstrapScoreThresholdValid = false;
			}
			validateForm();
		});
		
		
		adaptiveBootstrapScoreSelectionButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				boolean isAdaptive = adaptiveBootstrapScoreSelectionButton.getSelection();
				bnLearnNetworkBuild.setAdaptiveBootstrapScoreSelection(isAdaptive);
				if (isAdaptive) {
					bootstrapScoreThresholdText.setEnabled(false);
					bootstrapScoreThresholdText.setText("");
				} else {
					bootstrapScoreThresholdText.setEnabled(true);
					bootstrapScoreThresholdText.setText(String.valueOf(bnLearnNetworkBuild.getBootstrapScoreThreshold()));
				}
				validateForm();
			}
		});
		
		
		
	}
	private void validateForm() {
		isFormValid = isNetworkNameValid && isNBootstrapValid && isBootstrapScoreThresholdValid && isMaxParentsValid  && isBicScoreThresholdValid && isPValueThresholdValid ;
	}

	
	@Override
	protected Point getInitialSize() {
		// TODO Auto-generated method stub
		Point initialSize = super.getInitialSize();
		initialSize.y+=100;
		return initialSize;
	}
	
	@Override
	protected boolean isResizable() {
		return true;
	}
	
	@Override
	protected void okPressed() {
		
		if (runNetworkBuild()) {
			
			 super.okPressed();
			 return;
		} 
		
	}
	
	
	private boolean runNetworkBuild() {
		// TODO Auto-generated method stub
		// simulate a run with validation
		
		



		IValidationResult  validation =  getValidation();

		if(validation.isOK() && isFormValid) {
			setMessage("OK", IMessageProvider.INFORMATION);
			
			String buildId = activeProject.getUniqueBuildID(bnLearnNetworkBuild.getNetworkName());
			bnLearnNetworkBuild.setBuildID(buildId);
			activeProject.addNetworkBuild(bnLearnNetworkBuild);
			
			
			NetworkBuildJob job = new NetworkBuildJob(this.bnLearnNetworkBuild);
			job.setUser(true);
//			job.setActiveProject(activeProject);
//			job.setNetworkBuild();
			job.schedule();
			return true;

		} else {
			 setMessage("Configration is not valid", IMessageProvider.ERROR);
			// detailsForm.setImage(SharedImages.CANCEL);
			ErrorDialog.openError(getShell(), "Error",
					"Can not run current Task.",
					createMultiStatus(validation));
		}
		return false;

	}
	
	IValidationResult getValidation () {
		// validate network name 
		if (bnLearnNetworkBuild.getNetworkName() == null || bnLearnNetworkBuild.getNetworkName().isEmpty()) {
			return new ValidationResult(IValidationResult.ERROR, -1, "Network name cannot be empty.");
		}
		// check if the provided network name is unique
		String networkName = bnLearnNetworkBuild.getNetworkName();
		for (NetworkBuild networkBuild : activeProject.getNetworkBuilds()) {
			if (networkBuild.getNetworkName().equals(networkName)) {
				return new ValidationResult(IValidationResult.ERROR, -1, "Network name must be unique.");
			}
		}
		if (isFormValid) {
			return ValidationResult.Valid_RESULT;
		}
		else {
			return new ValidationResult(IValidationResult.ERROR, -1, "Invalid parameters.");
		}

	}

	private IStatus createMultiStatus(IValidationResult res) {

		
		
		
		if(res.isMultiValidation()) {
			//			Throwable ex = res.getException();
			//			if(ex == null) {
			//				ex = new Exception("Invalid Parameters");
			//			}
			MultiStatus ms = new MultiStatus(this.getClass(),  res.getCode(),res.getMessage(),res.getException());
			for(IValidationResult vs : res.getChildren()) {
				ms.add(new Status(vs.getSeverity(), this.getClass(),vs.getCode(),vs.getMessage(),vs.getException() ));
			}
			if(res.getException() == null) {

			}
			return ms;
		}
		else {
			return new Status(res.getSeverity(), this.getClass(),res.getCode(),res.getMessage(),res.getException() );
		}

	}
	
}
