package com.biotechvana.netools.ui;

import java.lang.reflect.InvocationTargetException;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.ui.rcp.status.CStatusLineManager;
import com.biotechvana.users.IUsersService;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.utils.WorkspaceUtils;


public class UIAddOn {
	@PostConstruct
	public void init(MApplication application, 
			IEclipseContext context, 
			IProgressService progressService) {
		IEclipseContext appContext = application.getContext();
		
		CStatusLineManager statusLineManager = ContextInjectionFactory.make(CStatusLineManager.class, context);
		appContext.set(IStatusLineManager.class, statusLineManager);
		appContext.set(IProgressService.class, progressService);
		
		ContextInjectionFactory.make(WorkspaceUtils.class,context);

	}
	@Inject
	@Optional
	public void applicationStarted(
			@UIEventTopic(UIEvents.UILifeCycle.APP_STARTUP_COMPLETE) Event event ,
			IUsersService usersService,
			Display display,
			IProgressService progressService,
			IProjectsManager projectsManager
			) {
	
		
		AppLoginStartup appLoginStartup = new AppLoginStartup(usersService,display);
		
		try {
			progressService.run(true, false,appLoginStartup);
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//progressService.showInDialog(display.getActiveShell(),loginJob);
		//loginJob.schedule();
			

	}
}
