package com.biotechvana.netools.ui;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.osgi.framework.Version;

import com.biotechvana.commons.GRPOApplication;
import com.biotechvana.commons.IGproApp;
import com.biotechvana.commons.UserApplication;
import com.biotechvana.utils.Constants;

/**
 * This is a stub implementation containing e4 LifeCycle annotated methods.<br />
 * There is a corresponding entry in <em>plugin.xml</em> (under the
 * <em>org.eclipse.core.runtime.products' extension point</em>) that references
 * this class.
 **/
@SuppressWarnings("restriction")
public class E4LifeCycle {

	@PostContextCreate
	void postContextCreate(IEclipseContext workbenchContext) {
		System.out.println("postContextCreate");
		// init everyThing avbout the application
		Constants.MODULE_ID = "NETools";
		//Version version = Activator.getContext().getBundle().getVersion();
		//String appVersion = version.getMajor()+"."+ version.getMinor()+"." + version.getMicro();
		
		
		
		GRPOApplication netoolsAPP = new GRPOApplication();
		workbenchContext.set(GRPOApplication.class, netoolsAPP);
		workbenchContext.set(IGproApp.class, netoolsAPP);

		
		
		UserApplication userApp = ContextInjectionFactory.make(UserApplication.class, workbenchContext);
		workbenchContext.set(UserApplication.class, userApp);
		
	}

	@PreSave
	void preSave(IEclipseContext workbenchContext) {
		System.out.println("preSave");

	}

	@ProcessAdditions
	void processAdditions(IEclipseContext workbenchContext) {
		System.out.println("processAdditions");
	}

	@ProcessRemovals
	void processRemovals(IEclipseContext workbenchContext) {
		System.out.println("processRemovals");
	}
}
