package com.biotechvana.netools.projects.jobs;


import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.Status;
public class TestJob extends Job  {

	
	public TestJob(String name) {
        super(name);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Running job...", IProgressMonitor.UNKNOWN);

        try {
            // Simulate a long-running task
            for (int i = 0; i < 10; i++) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Thread.sleep(1000); // Simulate work
                monitor.subTask("Processing " + (i + 1) + " of 10");
            }
        } catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        } finally {
            monitor.done();
        }

        return Status.OK_STATUS;
    }
}
