package com.biotechvana.netools.projects.jobs;


import java.io.File;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

import com.biotechvana.netools.projects.BNLearnNetworkBuild;
import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkBuild;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.RawDTFile;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.tracking.ExecStatus;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
public class NetworkBuildJob extends Job  {

	Project activeProject;
	
	IProjectsManager projectsManager;
	NetworkBuild bnLearnNetworkBuild;
	
	
	public NetworkBuildJob(NetworkBuild build) {
        super("Network Build");
        this.bnLearnNetworkBuild = build;
        this.activeProject = build.getProject();
        this.projectsManager = activeProject.getProjectManager();
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Running Build job ...", IProgressMonitor.UNKNOWN);

       
		String projectName = activeProject.getProjectName();
		// String projectID = activeProject.getProjectID();
        try {
        	SubMonitor subMonitor  = SubMonitor.convert(monitor, IProgressMonitor.UNKNOWN);
        	subMonitor.setTaskName("Saving Project");
        	
        	projectsManager.saveProject(activeProject, subMonitor);
    		
        	if (monitor.isCanceled()) {
        		// TODO :: handle
        		// handle cancellation
        		// delete uploaded file
        		// delete dataset
                return Status.CANCEL_STATUS;
            }
        	
        	subMonitor  = SubMonitor.convert(monitor, IProgressMonitor.UNKNOWN);
        	subMonitor.setTaskName("Building Network");
        	IValidationResult result = bnLearnNetworkBuild.buildProject(subMonitor);
    		
        	projectsManager.saveProject(activeProject,false,  subMonitor);
        	
			if (!result.isOK() ) {
				return Status.error(result.getMessage());
			}
        	
        	// to late to cancel 
        	monitor.done();
        	
        	
    		


    		
        	
        } catch (Exception e) {
            return Status.error("Can not start network build job");
        } finally {
            monitor.done();
        }
        

        return Status.OK_STATUS;
    }

	

	
}
