package com.biotechvana.netools.projects.handlers;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.ui.IDatasetViewer;

import jakarta.inject.Named;

public class RefreshDatasetHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(RefreshDatasetHandler.class);

	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject) {
		// Check if we have an active project
		return activeProject != null;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		IDatasetViewer datasetView,
    		@Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	datasetView.refreshDatasetView();
    	
    }
    
	
    
}
