package com.biotechvana.netools.projects.handlers;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.ui.dialogs.OpenProjectDialog;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.ProjectEntry;

public class OpenProjectHandler {
	@Execute
	public void execute_fix(IProjectsManager projectsManager, Shell shell , IProgressService progressService, MApplication app) {
		// Create and open the OpenProjectDialog
		OpenProjectDialog dialog = new OpenProjectDialog(shell, projectsManager);
		dialog.open(); // Open the dialog

		// Check if the user pressed "OK" and retrieve the selected project
		ProjectEntry selectedProject = dialog.getSelectedProjectEntry();
		if (selectedProject != null) {
			// Handle the selected project (e.g., load the project)
			// ... your logic to handle the selected project ...
			// prompt the user to save the current project if needed
			// Project currentProject = projectsManager.getCurrentProject();
			// if (currentProject != null && currentProject.isDirty()) {
			//     boolean save = MessageDialog.openConfirm(shell, "Save Project",
			//             "Do you want to save the current project before opening another project?");
			//     if (save) {
			//         projectsManager.saveProject(currentProject);
			//     }
			
			
			// now set the selected project as the current project
			try {
				
					
					projectsManager.setActiveProjectFromEntry(selectedProject);
				
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// show an error dialog
				String message = "Error opening project " + selectedProject.getProjectName();
				if (e.getMessage() != null) {
					message += ": " + e.getMessage();
				}
				MessageDialog.openError(shell, "Error", message);
			}
			
			
			
		} else {
			// User pressed "Cancel", ignore the selection
			Project currentProject = projectsManager.getActiveProject();
			if (currentProject != null) {
				projectsManager.setSelectedDesgin(currentProject.getNetworkDesigns().get(0));
				// currentProject.getNetworkDesigns().get(0);
				//app.getContext().set(IProjectsManager.SELECTED_DESIGN, currentProject.getNetworkDesigns().get(0));
			}
		}
		
		
	}
	
	public void execute(IProjectsManager projectsManager, Shell shell , IProgressService progressService, MApplication app) {
		// Create and open the OpenProjectDialog
		OpenProjectDialog dialog = new OpenProjectDialog(shell, projectsManager);
		dialog.open(); // Open the dialog

		// Check if the user pressed "OK" and retrieve the selected project
		ProjectEntry selectedProject = dialog.getSelectedProjectEntry();
		if (selectedProject != null) {
			// Handle the selected project (e.g., load the project)
			// ... your logic to handle the selected project ...
			// prompt the user to save the current project if needed
			// Project currentProject = projectsManager.getCurrentProject();
			// if (currentProject != null && currentProject.isDirty()) {
			//     boolean save = MessageDialog.openConfirm(shell, "Save Project",
			//             "Do you want to save the current project before opening another project?");
			//     if (save) {
			//         projectsManager.saveProject(currentProject);
			//     }
			
			
			// now set the selected project as the current project
			try {
				progressService.busyCursorWhile(monitor -> {
					monitor.beginTask("Opening project...", IProgressMonitor.UNKNOWN);
					
					projectsManager.setActiveProjectFromEntry(selectedProject);
					monitor.done();
				});
			} catch (InvocationTargetException | InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// show an error dialog
				String message = "Error opening project " + selectedProject.getProjectName();
				if (e.getMessage() != null) {
					message += ": " + e.getMessage();
				}
				MessageDialog.openError(shell, "Error", message);
			}
			
			
			
		} else {
			// User pressed "Cancel", ignore the selection
			Project currentProject = projectsManager.getActiveProject();
			if (currentProject != null) {
				projectsManager.setSelectedDesgin(currentProject.getNetworkDesigns().get(0));
				// currentProject.getNetworkDesigns().get(0);
				//app.getContext().set(IProjectsManager.SELECTED_DESIGN, currentProject.getNetworkDesigns().get(0));
			}
		}
		
		
	}
}
