package com.biotechvana.netools.projects.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.DatasetType;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkDesign;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.jobs.UploadRawDtFileJob;
import com.biotechvana.netools.ui.dialogs.NewDatasetDialog;

import org.eclipse.ui.PlatformUI;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import jakarta.inject.Named;

public class DesignSetActiveHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(DesignSetActiveHandler.class);

	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject) {
		// Check if we have an active project
		logger.debug("Active project: " + activeProject);
		return activeProject != null;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		@Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
    		@Named(IProjectsManager.SELECTED_DESIGN) NetworkDesign selectedDesign,

    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	
				if (selectedDesign == null) {
					logger.debug("DesignSetActiveHandler : selectedDesign is null");
					// show a message
					MessageDialog.openInformation(activeShell, "Set Active Design", "No network design is selected");
					return;
				}
				projectsManager.setActiveDesign(selectedDesign);
    }
    
	
    
}
