package com.biotechvana.netools.projects.handlers;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.jface.dialogs.MessageDialog;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;

import jakarta.inject.Inject;
import jakarta.inject.Named;

public class DeleteProjectHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(DeleteProjectHandler.class);

	
//	 Dataset selectedDataset;
//	@Inject
//	@Optional
//	public void setSelectedDataset(@Named(IProjectsManager.SELECTED_DATASET) Dataset selectedDataset) {
//		logger.info("Selected dataset: " + selectedDataset);
//		this.selectedDataset = selectedDataset;
//	}
	
	
	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject) {
		// Check if we have an active project
		logger.debug("activeProject : " + activeProject);
		// return selectedDataset != null;
		return activeProject != null;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		@Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	
				if (activeProject == null) {
					logger.error("No project selected");
					return;
				}
    	
    	logger.info("Deleting project " + activeProject.getProjectName());
    	
    	
    	// show a dialog to confirm the deletion
    	boolean confirmed = MessageDialog.openConfirm(activeShell, "Confirm Project Deletion", 
    			"Are you sure you want to delete the dataset " +  activeProject.getProjectName() + " ?");
    	if (!confirmed) {
    		return;
    	}
    	
		progressService.run(true, false, monitor -> {
			monitor.beginTask("Deleting Project " + activeProject.getProjectName(), 1);
			
			projectsManager.deleteProject(activeProject);
			
			
			
			monitor.done();
		});
    	
    	
    	
    }
    
    
}
