package com.biotechvana.netools.projects.handlers;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.jface.dialogs.MessageDialog;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;

import jakarta.inject.Inject;
import jakarta.inject.Named;

public class DeleteDatasetHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(DeleteDatasetHandler.class);

	
//	 Dataset selectedDataset;
//	@Inject
//	@Optional
//	public void setSelectedDataset(@Named(IProjectsManager.SELECTED_DATASET) Dataset selectedDataset) {
//		logger.info("Selected dataset: " + selectedDataset);
//		this.selectedDataset = selectedDataset;
//	}
	
	
	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.SELECTED_DATASET) Dataset selectedDataset) {
		// Check if we have an active project
		logger.debug("Selected dataset: " + selectedDataset);
		// return selectedDataset != null;
		return true;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		@Named(IProjectsManager.SELECTED_DATASET) Dataset selectedDataset,
    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	
				if (selectedDataset == null) {
					logger.error("No dataset selected");
					return;
				}
    	
    	logger.info("Deleting dataset " + selectedDataset.getDatasetName());
    	Project activeProject = projectsManager.getActiveProject();
    	
    	// show a dialog to confirm the deletion
    	boolean confirmed = MessageDialog.openConfirm(activeShell, "Confirm Deletion", 
    			"Are you sure you want to delete the dataset " + selectedDataset.getDatasetName() + "?");
    	if (!confirmed) {
    		return;
    	}
    	
		progressService.run(true, false, monitor -> {
			monitor.beginTask("Deleting dataset " + selectedDataset.getDatasetName(), 1);
			
			activeProject.removeDataset(selectedDataset,monitor);
			
			projectsManager.saveProject(activeProject, monitor);
			
			monitor.done();
		});
    	
    	
    	
    }
    
    
}
