package com.biotechvana.netools.projects;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.IWorkbench;

public class ProjectsManagerCreationFunction extends ContextFunction {

	@Override
	public Object compute(IEclipseContext context) {
		IEclipseContext injectContext = context;

		IWorkbench iworkbench = context.get(IWorkbench.class);
		
		if(iworkbench != null) {
			if(iworkbench.getApplication()!=null ) {
				IEclipseContext workbenchContext = iworkbench.getApplication().getContext();
				if(workbenchContext!=null) 
					injectContext = workbenchContext;	
			}
			
		}
		
		ProjectsManagerImpl projectManagerImpl =  injectContext.getLocal(ProjectsManagerImpl.class);
		if (projectManagerImpl == null) {
			projectManagerImpl =  ContextInjectionFactory.make(ProjectsManagerImpl.class, injectContext);
		}
		injectContext.set(ProjectsManagerImpl.class, projectManagerImpl);
		return projectManagerImpl;
	}

}
