package com.biotechvana.netools.projects;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;


@JsonTypeInfo(
		use = JsonTypeInfo.Id.NAME,
		include = JsonTypeInfo.As.PROPERTY,
		property = "type"
		)
@JsonSubTypes({
	@JsonSubTypes.Type(value = BNLearnNetworkBuild.class, name = "BNLearnNetworkBuild")// ,
	// @JsonSubTypes.Type(value = C.class, name = "C")
})
@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "buildID" , scope = NetworkBuild.class)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
public abstract class NetworkBuild {

	public static final String NETWORK_METHOD_BNLEAN = "BNLearn - pipeline";

	public enum NetworkScore {
		AIC,
		BIC,
		Loglik
	}

	@JsonBackReference //("project-network")
	protected Project project;


	String networkDesignID;

	String buildID;
	String networkID;

	String networkName;
	String networkDescription;

	String baseTaskName;
	String lastTaskName;
	int nRestart;

	private ExecStatus execStatus = ExecStatus.Unknown;


	public Project getProject() {
		return project;
	}

	public void setProject(Project project) {
		this.project = project;
		setNetworkTaskBaseName();

	}

	

	private void setNetworkTaskBaseName() {
		if (project == null || networkName == null) {
			baseTaskName = null;
			return;
		}
		baseTaskName = project.getProjectID() + "_build_" + networkName;
	}

	protected  String getBuildID() {
		return buildID;
	}

	//    public NetworkDesign getNetworkDesign() {
	//        return networkDesign;
	//    }

	public void setNetworkDesign(NetworkDesign networkDesign) {
		this.networkDesignID = networkDesign.getDesignID();
	}

	public String getNetworkName() {
		return networkName;
	}

	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	public String getNetworkDescription() {
		return networkDescription;
	}

	public void setNetworkDescription(String networkDescription) {
		this.networkDescription = networkDescription;
	}

	public String getLastJobId() {
		return lastTaskName ;
	}

	public ExecStatus getBuildStatus() {

		return execStatus;
	}

	public void setExecStatus(ExecStatus status) {
		this.execStatus = status;
		if (project != null)
			project.getProjectManager().networkBuildUpdated(this);
	}


	public abstract void postUpdate(SubmissionHistoryEntry trackHistory, IProgressMonitor monitor) ;

	public abstract IValidationResult buildProject(IProgressMonitor monitor);

	public String[] getNetworkTasks() {
		String[] tasks = new String[nRestart];
		for (int i = 0; i < nRestart; i++) {
			if (i == 0)
				tasks[i] = baseTaskName;
			else
				tasks[i] = baseTaskName + "_" + (i+1);
		}
		return tasks;
	}

	public abstract void createNetwork(IProgressMonitor monitor) ;


}
