package com.biotechvana.netools.projects;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;

@JsonTypeInfo(
	    use = JsonTypeInfo.Id.NAME,
	    include = JsonTypeInfo.As.PROPERTY,
	    property = "type"
	)
	@JsonSubTypes({
	    @JsonSubTypes.Type(value = RawDTFile.class, name = "RawDTFile")// ,
	   // @JsonSubTypes.Type(value = C.class, name = "C")
	})
@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "dataFilename")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
abstract public class DTFile  {
	
	
	
	private static final long serialVersionUID = 7948450890033488447L;
	/**
	 * dataFilename always inferred from dataset id
	 */
	protected String dataFilename;
	
	private ExecStatus execStatus = ExecStatus.Unknown;
	
	@JsonBackReference
	protected Dataset dataset;
	
	
	/**
	 * A list of tasks id/name that worked on this file.
	 */
	protected List<String> preProcessorsIds = new ArrayList<String>();
	
	
//	protected List<Variable> dataVariables = new ArrayList<Variable>();
	
	
	@JsonCreator
	public DTFile() {
		
	}
	
	public String getFileName() {
		return dataFilename;
	}
	
	
	public abstract String getDescription() ;
	
	
	
	
	
	public ExecStatus getExecStatus() {
		return execStatus;
	}
	
	public void setExecStatus(ExecStatus execStatus) {
		this.execStatus = execStatus;
		if (dataset != null && dataset.getProject() != null) {
			dataset.getProject().getProjectManager().dtFileUpdated(this);
		}
		
	}
	
	
	abstract public IValidationResult getValidationResult();
	

	public Dataset getDataset() {
		return dataset;
	}

	public void setDataset(Dataset dataset) {
		this.dataset = dataset;
		setFileName(dataset.getDatasetID());
	}
	
	/**
	 * get the last job id that worked on this
	 * @return
	 */
	public String getLastJobId() {
		if (preProcessorsIds.isEmpty())
			return null;
		return preProcessorsIds.get(preProcessorsIds.size() - 1);
	}

	public abstract void postUpdate(SubmissionHistoryEntry trackHistory, IProgressMonitor monitor);

	protected abstract void setFileName(String baseName);

	protected abstract String getFilePath();
	
	
	
}
