package com.biotechvana.netools.models.json;
import java.io.IOException;
import java.util.Map;

import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;

import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.Node;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
/**
 * Serializer for DefaultDirectedWeightedGraph
 */
public class DDWGraphSerializer extends JsonSerializer<DefaultDirectedWeightedGraph<Node,Edge>>   {

	@Override
	public void serialize(DefaultDirectedWeightedGraph<Node,Edge> value, JsonGenerator gen,
			SerializerProvider serializers) throws IOException {
		gen.writeStartObject();
		
		// Write nodes array
		gen.writeFieldName("nodes");
		gen.writeStartArray();
		for(Node node : value.vertexSet()) {
			serializers.defaultSerializeValue(node, gen);
		}
		gen.writeEndArray();
		
		// Write edges array
		gen.writeFieldName("edges");
		gen.writeStartArray();
		for(Edge edge : value.edgeSet()) {
//			Node source = value.getEdgeSource(edge);
//			Node target = value.getEdgeTarget(edge);
//			// Write edge object
//			gen.writeStartObject();
//			gen.writeStringField("source", source.getId());
//			gen.writeStringField("target", target.getId());
//			// write edge object 
//			gen.writeObjectField("edge", edge);
//			// serializers.defaultSerializeValue(edge, gen);
//			gen.writeEndObject();
			serializers.defaultSerializeValue(edge, gen);
			
		}
		gen.writeEndArray();
		
		gen.writeEndObject();
	}

	

}
