package com.biotechvana.netools.models.json;

import java.io.IOException;
import java.util.HashMap;

import org.jgrapht.graph.DefaultDirectedWeightedGraph;

import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.Node;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DDWGraphDeserializer extends JsonDeserializer<DefaultDirectedWeightedGraph<? extends Node,? extends  Edge>>   {

	@Override
	public DefaultDirectedWeightedGraph<Node, Edge> deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JacksonException {
		DefaultDirectedWeightedGraph<Node, Edge> graph = new DefaultDirectedWeightedGraph<Node, Edge>(Edge.class);
		ObjectMapper mapper = (ObjectMapper) p.getCodec();
		JsonNode rootNode = mapper.readTree(p);
		// print the rootNode
		System.out.println(rootNode);
		// Read nodes array
		JsonNode nodesNode = rootNode.get("nodes");
		// hash map to store nodes
		HashMap<String, Node> nodesMap = new HashMap<String, Node>();
		if (nodesNode != null && nodesNode.isArray()) {
			for (JsonNode nodeJson : nodesNode) {
				Node node = mapper.treeToValue(nodeJson, Node.class);
				
				graph.addVertex(node);
				nodesMap.put(node.getId(), node);
			}
		}
		
		// Read edges array
		JsonNode edgesNode = rootNode.get("edges");
		// print the edgesNode
		
		if (edgesNode != null && edgesNode.isArray()) {
			for (JsonNode edgeJson : edgesNode) {
				System.out.println(edgeJson);
				Edge edge = mapper.treeToValue(edgeJson, Edge.class);
				String sourceId = edge.getSource();
				String targetId = edge.getTarget();
//				String sourceId = mapper.treeToValue(edgeJson.get("source"), String.class);
//				String targetId =  mapper.treeToValue(edgeJson.get("target"), String.class);
//				Edge edge = mapper.treeToValue(edgeJson.get("edge"), Edge.class);
//				// Find source and target nodes
				Node sourceNode =  nodesMap.get(sourceId);
				Node targetNode = nodesMap.get(targetId);
//				for (Node node : graph.vertexSet()) {
//					if (node.getId().equals(sourceId)) {
//						sourceNode = node;
//					}
//					if (node.getId().equals(targetId)) {
//						targetNode = node;
//					}
//					if (sourceNode != null && targetNode != null) {
//						break;
//					}
//				}
				
				if (sourceNode != null && targetNode != null) {
					graph.addEdge(sourceNode, targetNode, edge);
				}
			}
		}
		
		return graph;
	}

}
