package com.biotechvana.netools.models;

public class VisLayout {
	public enum Smoothness {
		// Possible options: 'dynamic', 'continuous', 'discrete', 'diagonalCross', 'straightCross', 'horizontal', 'vertical', 'curvedCW', 'curvedCCW', 'cubicBezier'
		DYNAMIC("dynamic", "Dynamic"),
		CONTINUOUS("continuous","Continuous"),
		DISCRETE("discrete","Discrete"),
		DIAGONAL_CROSS("diagonalCross","Diagonal Cross"),
		STRAIGHT_CROSS("straightCross","Straight Cross"),
		HORIZONTAL("horizontal","Horizontal"),
		VERTICAL("vertical","Vertical"),
		CURVED_CW("curvedCW","Curved CW"),
		CURVED_CCW("curvedCCW","Curved CCW"),
		CUBIC_BEZIER("cubicBezier","Cubic Bezier");
		
		String key;
		String value;
		Smoothness(String key, String value) {
			this.key = key;
			this.value = value;
		}	
		
		public String getKey() {
			return key;
		}

		public String getValue() {
			return value;
		}
		
	}
	
	
	boolean edgeSmoothnessEnabled = false;
	
	double roundness ; //[0, 1]
	
	// type 
	Smoothness smoothness = Smoothness.DISCRETE;
	
	// ######################
	
	boolean physicsEnabled;


	// theta [barnesHut, forceAtlas2Based]
	double theta; // [0, 1]
	
	// gravitationalConstant
	double gravitationalConstant;
	
	// centralGravity
	double centralGravity;
	// springLength
	double springLength;
	// springConstant
	double springConstant;
	// damping
	double damping; // [0,1]

	// avoidOverlap
	double avoidOverlap; // [0, 1]

	
	// nodeDistance [repulsion,hierarchicalRepulsion]
	double nodeDistance; // [0, ...]
	
	
	// int maxVelocity from 0 to 150
	int maxVelocity ;
	// better less than 1
	double minVelocity ;

	double timestep; // max 1

	
	static public void setForceAtlas2BasedDefaults(VisLayout visLayout) {
		visLayout.theta = 0.5;
        visLayout.gravitationalConstant = -100;
        visLayout.centralGravity = 0.01;
        visLayout.springLength = 100;
        visLayout.springConstant = 0.08;
        visLayout.damping = 0.4;
        visLayout.avoidOverlap = 0;
        visLayout.maxVelocity = 150;
        visLayout.minVelocity = 0.1;
        visLayout.timestep = 0.5;
    }
	
	static public void setBarnesHutDefaults(VisLayout visLayout) {
		visLayout.theta = 0.5;
		visLayout.gravitationalConstant = -100;
		visLayout.centralGravity = 0.01;
		visLayout.springLength = 100;
		visLayout.springConstant = 0.08;
		visLayout.damping = 0.4;
		visLayout.avoidOverlap = 0;
		visLayout.maxVelocity = 150;
		visLayout.minVelocity = 0.1;
		visLayout.timestep = 0.5;
	}
	
	// TODO :: transform to JSON to set the vis in the frontend
}
