//package com.biotechvana.netools.models;
//
//import static org.junit.jupiter.api.Assertions.*;
//import org.junit.jupiter.api.BeforeEach;
//import org.junit.jupiter.api.Test;
//import java.beans.PropertyChangeEvent;
//import java.beans.PropertyChangeListener;
//
//
//
//
//public class NodeTest {
//
//    private Node node;
//
//    @BeforeEach
//    public void setUp() {
//        node = new Node("1");
//    }
//
//    @Test
//    public void testGetId() {
//        assertEquals("1", node.getId());
//    }
//
//    @Test
//    public void testSetId() {
//        node.setId("2");
//        assertEquals("2", node.getId());
//    }
//
//    @Test
//    public void testSetBorderWidth() {
//        node.setBorderWidth(5);
//        assertEquals(5, node.getBorderWidth());
//    }
//
//    @Test
//    public void testSetOpacity() {
//        node.setOpacity(0.5);
//        assertEquals(0.5, node.getOpacity());
//    }
//
//    @Test
//    public void testSetGroup() {
//        node.setGroup("group1");
//        assertEquals("group1", node.getGroup());
//    }
//
//    @Test
//    public void testSetHidden() {
//        node.setHidden(true);
//        assertTrue(node.isHidden());
//    }
//
//    @Test
//    public void testSetLabel() {
//        node.setLabel("Node Label");
//        assertEquals("Node Label", node.getLabel());
//    }
//
//    @Test
//    public void testSetLabelHighlightBold() {
//        node.setLabelHighlightBold(false);
//        assertFalse(node.isLabelHighlightBold());
//    }
//
//    @Test
//    public void testSetLevel() {
//        node.setLevel(2);
//        assertEquals(2, node.getLevel());
//    }
//
//    @Test
//    public void testSetMass() {
//        node.setMass(2.5);
//        assertEquals(2.5, node.getMass());
//    }
//
//    @Test
//    public void testSetShape() {
//        node.setShape("circle");
//        assertEquals("circle", node.getShape());
//    }
//
//    @Test
//    public void testSetPhysics() {
//        node.setPhysics(false);
//        assertFalse(node.isPhysics());
//    }
//
//    @Test
//    public void testSetSize() {
//        node.setSize(30);
//        assertEquals(30, node.getSize());
//    }
//
//    @Test
//    public void testSetTitle() {
//        node.setTitle("Node Title");
//        assertEquals("Node Title", node.getTitle());
//    }
//
//    @Test
//    public void testSetValue() {
//        node.setValue(3.5);
//        assertEquals(3.5, node.getValue());
//    }
//
//    @Test
//    public void testSetX() {
//        node.setX(100.0);
//        assertEquals(100.0, node.getX());
//    }
//
//    @Test
//    public void testSetY() {
//        node.setY(200.0);
//        assertEquals(200.0, node.getY());
//    }
//
//    @Test
//    public void testSetColor() {
//        node.setColor("#FFFFFF");
//        assertEquals("#FFFFFF", node.getColor());
//    }
//
//    @Test
//    public void testSetColorBorder() {
//        node.setColorBorder("#000000");
//        assertEquals("#000000", node.getColorBorder());
//    }
//
//    @Test
//    public void testSetColorHighlight() {
//        node.setColorHighlight("#FF0000");
//        assertEquals("#FF0000", node.getColorHighlight());
//    }
//
//    @Test
//    public void testSetColorHighlightBorder() {
//        node.setColorHighlightBorder("#00FF00");
//        assertEquals("#00FF00", node.getColorHighlightBorder());
//    }
//
//    @Test
//    public void testSetColorHover() {
//        node.setColorHover("#0000FF");
//        assertEquals("#0000FF", node.getColorHover());
//    }
//
//    @Test
//    public void testSetColorHoverBorder() {
//        node.setColorHoverBorder("#FFFF00");
//        assertEquals("#FFFF00", node.getColorHoverBorder());
//    }
//
//    @Test
//    public void testToJson() {
//        node.setBorderWidth(5);
//        node.setOpacity(0.5);
//        node.setGroup("group1");
//        node.setHidden(true);
//        node.setLabel("Node Label");
//        node.setLabelHighlightBold(false);
//        node.setLevel(2);
//        node.setMass(2.5);
//        node.setShape("circle");
//        node.setPhysics(false);
//        node.setSize(30);
//        node.setTitle("Node Title");
//        node.setValue(3.5);
//        node.setX(100.0);
//        node.setY(200.0);
//        node.setColor("#FFFFFF");
//        node.setColorBorder("#000000");
//        node.setColorHighlight("#FF0000");
//        node.setColorHighlightBorder("#00FF00");
//        node.setColorHover("#0000FF");
//        node.setColorHoverBorder("#FFFF00");
//
//        JSONObject json = node.toJson();
//        assertEquals("1", json.getString("id"));
//        assertEquals(5, json.getInt("borderWidth"));
//        assertEquals(0.5, json.getDouble("opacity"));
//        assertEquals("group1", json.getString("group"));
//        assertTrue(json.getBoolean("hidden"));
//        assertEquals("Node Label", json.getString("label"));
//        assertFalse(json.getBoolean("labelHighlightBold"));
//        assertEquals(2, json.getInt("level"));
//        assertEquals(2.5, json.getDouble("mass"));
//        assertEquals("circle", json.getString("shape"));
//        assertFalse(json.getBoolean("physics"));
//        assertEquals(30, json.getInt("size"));
//        assertEquals("Node Title", json.getString("title"));
//        assertEquals(3.5, json.getDouble("value"));
//        assertEquals(100.0, json.getDouble("x"));
//        assertEquals(200.0, json.getDouble("y"));
//        assertEquals("#FFFFFF", json.getJSONObject("color").getString("background"));
//        assertEquals("#000000", json.getJSONObject("color").getString("border"));
//        assertEquals("#FF0000", json.getJSONObject("color").getJSONObject("highlight").getString("background"));
//        assertEquals("#00FF00", json.getJSONObject("color").getJSONObject("highlight").getString("border"));
//        assertEquals("#0000FF", json.getJSONObject("color").getJSONObject("hover").getString("background"));
//        assertEquals("#FFFF00", json.getJSONObject("color").getJSONObject("hover").getString("border"));
//    }
//
//    @Test
//    public void testPropertyChangeListener() {
//        PropertyChangeListener listener = new PropertyChangeListener() {
//            @Override
//            public void propertyChange(PropertyChangeEvent evt) {
//                assertEquals("id", evt.getPropertyName());
//                assertEquals("1", evt.getOldValue());
//                assertEquals("2", evt.getNewValue());
//            }
//        };
//        node.addPropertyChangeListener(listener);
//        node.setId("2");
//        node.removePropertyChangeListener(listener);
//    }
//}
