package com.biotechvana.netools.models;

import org.eclipse.swt.graphics.Color;
import org.json.JSONObject;

/**
 * Interface for Node attributes -- visualization attributes for nodes in viewer
 */
public interface INode {
	

	String getId();

	void setId(String id);

	int getBorderWidth();

	void setBorderWidth(int borderWidth);

	int getBorderWidthSelected();

	void setBorderWidthSelected(int borderWidthSelected);

	double getOpacity();

	void setOpacity(double opacity);

	String getGroup();

	void setGroup(String group);

	boolean isHidden();

	void setHidden(boolean hidden);

	String getLabel();

	void setLabel(String label);

	boolean isLabelHighlightBold();

	void setLabelHighlightBold(boolean labelHighlightBold);

	int getLevel();

	void setLevel(int level);

	double getMass();

	void setMass(double mass);

	String getShape();

	void setShape(String shape);

	boolean isPhysics();

	void setPhysics(boolean physics);

	int getSize();

	void setSize(int size);

	String getTitle();

	void setTitle(String title);

	double getValue();

	void setValue(double value);

	double getX();

	void setX(double x);

	double getY();

	void setY(double y);

	String getColor();

	void setColor(String color);

	String getColorBorder();

	void setColorBorder(String colorBorder);

	String getColorHighlight();

	void setColorHighlight(String colorHighlight);

	String getColorHighlightBorder();

	void setColorHighlightBorder(String colorHighlightBorder);

	String getColorHover();

	void setColorHover(String colorHover);

	String getColorHoverBorder();

	void setColorHoverBorder(String colorHoverBorder);

	// Method to convert Node object to JSONObject
	JSONObject toJson();

}