package com.biotechvana.netools.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

import org.jgrapht.graph.DefaultEdge;
import org.json.JSONObject;

import com.biotechvana.netools.models.Node.Defaults;
import com.biotechvana.netools.projects.Variable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Edge extends DefaultEdge implements IEdge, IAttributable {

	public static class Defaults {
		public static final String COLOR = "97C2FC";
		public static final String COLOR_HIGHLIGHT = "D2E5FF";
		public static final String COLOR_HOVER = "D2E5FF";
		public static final double OPACITY = 1.0;
		public static final double WIDTH = 1.0;
		public static final boolean DASHES = false;
		public static final boolean HIDDEN = false;
		public static final String LABEL = "";
		public static final String SOURCE = "";
		public static final String TARGET = "";
		public static final double WEIGHT = 1.0;
		public static final String ARROWS = "to";

	}

	private Map<String, Object> viewerAttributes = new HashMap<>();
	private Map<String, Object> customAttributes = new HashMap<>();

	transient private Variable linkedVariable = null;

	transient private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

	public Edge() {

	}

	@Override
	public int hashCode() {
		return super.hashCode();
		// return getId().hashCode();
	}

	// Getters and setters for all attributes with property change support
	
	@Override
	public String getId() {
		return (String) viewerAttributes.get("edgeID");
	}

	@Override
	public void setId(String id) {
		String oldId = (String) viewerAttributes.get("edgeID");
		if (id.equals(oldId)) return;
		viewerAttributes.put("edgeID", id);
		pcs.firePropertyChange("edgeID", oldId, id);
	}

	@Override
	public String getSource() {
		return (String) viewerAttributes.get("sourceID");
	}

	@Override
	public void setSource(String id) {
		String oldId = (String) viewerAttributes.get("sourceID");
		if (id.equals(oldId)) return;
		viewerAttributes.put("sourceID", id);
		pcs.firePropertyChange("sourceID", oldId, id);
	}

	@Override
	public String getTarget() {
		return (String) viewerAttributes.get("targetID");
	}

	@Override
	public void setTarget(String id) {
		String oldId = (String) viewerAttributes.get("targetID");
		if (id.equals(oldId)) return;
		viewerAttributes.put("targetID", id);
		pcs.firePropertyChange("targetID", oldId, id);
	}

	@Override
	public String getLabel() {
		return (String) viewerAttributes.get("label");
	}

	@Override
	public void setLabel(String label) {
		String oldLabel = (String) viewerAttributes.get("label");
		if (label.equals(oldLabel)) return;
		viewerAttributes.put("label", label);
		pcs.firePropertyChange("label", oldLabel, label);
	}

	@Override
	public String getColor() {
		return (String) viewerAttributes.getOrDefault("color", Defaults.COLOR);
	}

	@Override
	public void setColor(String color) {
		String oldColor = (String) viewerAttributes.getOrDefault("color", Defaults.COLOR);
		if (color.equals(oldColor)) return;
		viewerAttributes.put("color", color);
		pcs.firePropertyChange("color", oldColor, color);
	}

	@Override
	public String getColorHighlight() {
		return (String) viewerAttributes.getOrDefault("colorHighlight", Defaults.COLOR_HIGHLIGHT);
	}

	@Override
	public void setColorHighlight(String colorHighlight) {
		String oldColorHighlight = (String) viewerAttributes.getOrDefault("colorHighlight", Defaults.COLOR_HIGHLIGHT);
		if (colorHighlight.equals(oldColorHighlight)) return;
		viewerAttributes.put("colorHighlight", colorHighlight);
		pcs.firePropertyChange("colorHighlight", oldColorHighlight, colorHighlight);
	}

	@Override
	public String getColorHover() {
		return (String) viewerAttributes.getOrDefault("colorHover", Defaults.COLOR_HOVER);
	}

	@Override
	public void setColorHover(String colorHover) {
		String oldColorHover = (String) viewerAttributes.getOrDefault("colorHover", Defaults.COLOR_HOVER);
		if (colorHover.equals(oldColorHover)) return;
		viewerAttributes.put("colorHover", colorHover);
		pcs.firePropertyChange("colorHover", oldColorHover, colorHover);
	}

	@Override
	public double getOpacity() {
		return (double) viewerAttributes.getOrDefault("opacity", Defaults.OPACITY);
	}

	@Override
	public void setOpacity(double opacity) {
		double oldOpacity = (double) viewerAttributes.getOrDefault("opacity", Defaults.OPACITY);
		if (opacity == oldOpacity) return;
		viewerAttributes.put("opacity", opacity);
		pcs.firePropertyChange("opacity", oldOpacity, opacity);
	}

	@Override
	public double getWidth() {
		return (double) viewerAttributes.getOrDefault("width", Defaults.WIDTH);
	}

	@Override
	public void setWidth(double width) {
		double oldWidth = (double) viewerAttributes.getOrDefault("width", Defaults.WIDTH);
		if (width == oldWidth) return;
		viewerAttributes.put("width", width);
		pcs.firePropertyChange("width", oldWidth, width);
	}

	@Override
	public boolean areDashesShown() {
		return (boolean) viewerAttributes.getOrDefault("dashes", Defaults.DASHES);
	}

	@Override
	public void setDashes(boolean dashes) {
		boolean oldDashes = (boolean) viewerAttributes.getOrDefault("dashes", Defaults.DASHES);
		if (dashes == oldDashes) return;
		viewerAttributes.put("dashes", dashes);
		pcs.firePropertyChange("dashes", oldDashes, dashes);
	}

	@Override
	public boolean isHidden() {
		return (boolean) viewerAttributes.getOrDefault("hidden", Defaults.HIDDEN);
	}

	@Override
	public void setHidden(boolean hidden) {
		boolean oldHidden = (boolean) viewerAttributes.getOrDefault("hidden", Defaults.HIDDEN);
		if (hidden == oldHidden) return;
		viewerAttributes.put("hidden", hidden);
		pcs.firePropertyChange("hidden", oldHidden, hidden);
	}

	@Override
	public double getWeight() {
		return (double) viewerAttributes.getOrDefault("weight", Defaults.WEIGHT);
	}

	@Override
	public void setWeight(double weight) {
		double oldWeight = (double) viewerAttributes.getOrDefault("weight", Defaults.WEIGHT);
		if (weight == oldWeight) return;
		viewerAttributes.put("weight", weight);
		pcs.firePropertyChange("weight", oldWeight, weight);
	}

	public String getArrows() {
		return (String) viewerAttributes.getOrDefault("arrows", Defaults.ARROWS);
	}

	public void setArrows(String arrows) {
		String oldArrows = (String) viewerAttributes.getOrDefault("arrows", Defaults.ARROWS);
		if (arrows.equals(oldArrows)) return;
		viewerAttributes.put("arrows", arrows);
		pcs.firePropertyChange("arrows", oldArrows, arrows);
	}
	
	
	// Method to convert Node object to JSONObject
    @Override
    public void toJson(JSONObject edgeJson) {
        edgeJson.put("id", getId());
        edgeJson.put("label", getLabel());
        edgeJson.put("from", getSource());
        edgeJson.put("to", getTarget());
        edgeJson.put("arrows", getArrows());
        //edgeJson.put("sourceID", getSource());
        //edgeJson.put("targetID", getTarget());
        if (viewerAttributes.containsKey("opacity")) edgeJson.put("opacity", getOpacity());
		if (viewerAttributes.containsKey("width")) edgeJson.put("width", getWidth());
		if (viewerAttributes.containsKey("dashes")) edgeJson.put("dashes", areDashesShown());
		if (viewerAttributes.containsKey("hidden")) edgeJson.put("hidden", isHidden());
		//if (viewerAttributes.containsKey("weight")) edgeJson.put("weight", getWeight());
		//if (viewerAttributes.containsKey("arrows")) edgeJson.put("arrows", getArrows());
		
		//edgeJson.put("color", getColor());
		//edgeJson.put("colorHighlight", getColorHighlight());
		//edgeJson.put("colorHover", getColorHover());
		colorsToJson(edgeJson);
	}
    
    // Method to convert color properties to JSONObject
    private void colorsToJson(JSONObject jsonObject) {
        if ( !viewerAttributes.containsKey("colorHighlight") &&
           !viewerAttributes.containsKey("colorHover")) {
            if (viewerAttributes.containsKey("color"))
                jsonObject.put("color", getColor());
            return;
        }

        JSONObject colorObject = new JSONObject();
        jsonObject.put("color", colorObject);
        if (viewerAttributes.containsKey("color")) {
            colorObject.put("color", getColor());
        }

        JSONObject highlightObject = new JSONObject();
        if (viewerAttributes.containsKey("colorHighlight")) {
            highlightObject.put("color", getColorHighlight());
        }
        colorObject.put("highlight", highlightObject);
            
        if (viewerAttributes.containsKey("colorHighlight")) {
                colorObject.put("highlight", getColorHighlight());
        }

        JSONObject hoverObject = new JSONObject();
        if (viewerAttributes.containsKey("colorHover")) {
            hoverObject.put("color", getColorHover());
        }
        colorObject.put("hover", hoverObject);
        
        if (viewerAttributes.containsKey("colorHover")) {
            colorObject.put("hover", getColorHover());
        }
    }
    
    
 // Methods to add and remove property change listeners
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    // Methods for custom attributes
    @Override
    public Object getAttribute(String key) {
        return customAttributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        Object oldValue = customAttributes.get(key);
        if (value != null && value.equals(oldValue)) return;
        customAttributes.put(key, value);
        pcs.firePropertyChange(key, oldValue, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return new HashMap<>(customAttributes);
    }
    
    public Variable getLinkedVariable() {
    	        return linkedVariable;
    }

	public void setLinkedVariable(Variable linkedVariable) {
		this.linkedVariable = linkedVariable;
	}


}
