function generateTestData2() {
    const nodes = [];
    const edges = [];
    const numNodes = 20;
    const numEdges = 40;

    // Create nodes with the same shape and grouped for coloring
    for (let i = 1; i <= numNodes; i++) {
        nodes.push({
            id: 'Node ' + i,
            label: 'Node ' + i,
            shape: 'circle', // Same shape for all nodes
            color: { background: '#97C2FC' , border: 'yellow' }, // Random color for each node
            group: 'group1', // Grouping for coloring
            font: '14px arial'
        });
    }

    // Create edges ensuring at least 40 edges
    while (edges.length < numEdges) {
        const fromNode = 'Node ' + ( Math.floor(Math.random() * numNodes) + 1 );
        const toNode = 'Node ' + ( Math.floor(Math.random() * numNodes) + 1 );
        let fromNodeValue = fromNode.split(" ")[1];
        let toNodeValue = toNode.split(" ")[1];
        id = generateUniqueEdgeId(fromNodeValue, toNodeValue);
        
        if (fromNode !== toNode) { // Prevent self-loops
            edges.push({
            	id: id,
                from: fromNode,
                to: toNode,
                arrows: 'to',
                color: '#848484',
                width: 2
            });
        }
    }

    return {
        nodes: nodes,
        edges: edges
    };
}

const edgeCount = {};
function generateUniqueEdgeId(fromNodeValue, toNodeValue) {
    let baseId = `X${fromNodeValue}_X${toNodeValue}`;
    
    if (edgeCount[baseId]) {
        edgeCount[baseId]++; 
        return `${baseId}_${edgeCount[baseId]}`;
    } else {
        edgeCount[baseId] = 1; 
        return baseId;
    }
}


function getRandomColor() {
    const letters = '0123456789ABCDEF';
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
}

function setData() {
    data = generateTestData2();
    initializeNetwork(data);
}

setData();


togglePhysics(false);



var options = {
    interaction: {
        multiselect: true,
    },
};

network.setOptions(options);


/*window.nodes.update({
      id: "Node 1",
      color: {
            border: "red"
          }
    });*/


