package com.biotechvana.netools.internal;

import org.eclipse.swt.graphics.Image;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.tracking.ExecStatus;

public class ViewUtils {

	public static Image getExecStatusImage(ExecStatus execStatus) {
		if (execStatus == null)
			return SharedImages.CANCEL;
		switch (execStatus) {
		case Failed:
			return SharedImages.ERROR;
		case Running:
			return SharedImages.PROCESS_INFO;
		case Finished:
			return SharedImages.ACCEPT;
		case Warning :
			return SharedImages.FILE_WARNING;
		case Unknown:
			return SharedImages.CANCEL;

		default:
			return SharedImages.PROCESS_INFO;
		}
	}

}
