package com.biotechvana.netools.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.biotechvana.netools.ISelectionEvent;
import com.biotechvana.netools.ISelectionListener;
import com.biotechvana.netools.ISelectionManager;
import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.INode;
import com.biotechvana.netools.models.Node;

public class SelectionManager implements ISelectionManager {
	
	private final List<ISelectionListener> listeners = new ArrayList<>();

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        listeners.remove(listener);
    }

    private void notifyNodesSelectionChanged(ISelectionEvent event) {
        for (ISelectionListener listener : listeners) {
            listener.nodesSelectionChanged(event);
        }
    }
    private void notifyEdgesSelectionChanged(ISelectionEvent event) {
        for (ISelectionListener listener : listeners) {
            listener.edgesSelectionChanged(event);
        }
    }

    class SelectionEvent implements ISelectionEvent{

    	Set<Node> selectedNodes = new HashSet<>();
    	Set<Edge> selectedEdges = new HashSet<>();
    	
		@Override
		public Set<Node> getSelectedNodes() {
			// TODO Auto-generated method stub
			return selectedNodes;
		}

		@Override
		public Set<Edge> getSelectedEdges() {
			// TODO Auto-generated method stub
			return selectedEdges;
		}
		
		
		protected void setNodes(Set<Node> selectedNodes) {
			this.selectedNodes = selectedNodes;
		}
		
		protected void setEdges(Set<Edge> selectedEdges) {
			this.selectedEdges = selectedEdges;
		}

		@Override
		public Object getSource() {
			// TODO Auto-generated method stub
			return null;
		}
        
    }

   
    
    
    Set<Node> selectedNodes = new HashSet<>();
    Set<Edge> selectedEdges = new HashSet<>();

	@Override
	public void addSelectionNodes(Node node) {
		// TODO Auto-generated method stub
		selectedNodes.add(node);
		nodesSelectionChanged();
	}

	@Override
	public void addSelectionNodes(Set<Node> newSelection) {
		// TODO Auto-generated method stub
		selectedNodes.addAll(newSelection);
		nodesSelectionChanged();
	}
	
	@Override
	public void addSelectionEdges(Edge edge) {
		// TODO Auto-generated method stub
		selectedEdges.add(edge);
		edgesSelectionChanged();
	}

	@Override
	public void addSelectionEdges(Set<Edge> newSelection) {
		// TODO Auto-generated method stub
		selectedEdges.addAll(newSelection);
		edgesSelectionChanged();
	}

	@Override
	public void clearSelectionNodes() {
		// TODO Auto-generated method stub
		selectedNodes.clear();
		nodesSelectionChanged();
	}
	
	@Override
	public void clearSelectionEdges() {
		// TODO Auto-generated method stub
		selectedEdges.clear();
		edgesSelectionChanged();
	}
	
	
	private void nodesSelectionChanged() {
		 SelectionEvent event =  new SelectionEvent();
		 event.setNodes(new HashSet<Node>(selectedNodes));
		 event.setEdges(new HashSet<Edge>(selectedEdges));
		 notifyNodesSelectionChanged((ISelectionEvent) event);
	}
	
	private void edgesSelectionChanged() {
		 SelectionEvent event =  new SelectionEvent();
		 event.setNodes(new HashSet<Node>(selectedNodes));
		 event.setEdges(new HashSet<Edge>(selectedEdges));
	     notifyEdgesSelectionChanged((ISelectionEvent) event);
	}

	@Override
	public void setSelectedNodes(Set<Node> nodesSelected) {
		selectedNodes.clear();
		selectedNodes.addAll(nodesSelected);
		nodesSelectionChanged();
		
	}

	@Override
	public void setSelectedEdges(Set<Edge> edgesSelected) {
		selectedEdges.clear();
		selectedEdges.addAll(edgesSelected);
		edgesSelectionChanged();
		
	}
	
    // internally handles selection change , store current selection
    // add methods to set or add a nodes to selection, etc
    
    

}
