package com.biotechvana.netools.internal;

import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.ui.IFilterView;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class FilterView implements  IFilterView {

	FormToolkit toolkit;
	Form detailsForm;
	
	private Composite mainBody;
	
	Dataset selected_dataset;
	IProjectsManager projectsManager;
	
	@Inject
	IProgressService progressService;


	@Inject
	UISynchronize sync;
	
	TableViewer nodesTableViewer;
	TableViewer edgesTableViewer;
	private TabFolder tabFolder;
	
	@Inject
	@Optional
	public void setSelectedDataset(@Named(IProjectsManager.SELECTED_DATASET) Dataset dataset) {
		selected_dataset = dataset;
		updateUI();
	}
	
	private void updateUI() {
		if (detailsForm == null || detailsForm.isDisposed()) {
			return;
		}
		if (selected_dataset != null) {
			detailsForm.setText("Filtering Option - " + selected_dataset.getDatasetName());
			// Clear previous content
			for (Control child : detailsForm.getBody().getChildren()) {
				child.dispose();
			}
			// Create new content based on dataset type
			switch (selected_dataset.getDatasetType()) {
				case GENERAL:
					createGeneralUI(detailsForm.getBody());
					break;
				case COVARIATE:
					createCovariateUI(detailsForm.getBody());
					break;
				// Add cases for other dataset types as needed
				default:
					createDefaultUI(detailsForm.getBody());
					break;
			}
			detailsForm.getBody().layout(true, true);
		} else {
			detailsForm.setText("Filtering Option - No dataset selected");
			// Clear previous content
			for (Control child : detailsForm.getBody().getChildren()) {
				child.dispose();
			}
			toolkit.createLabel(detailsForm.getBody(), "No dataset selected");
		}
	}

	@PostConstruct
	public void createPartControl(Composite parent, IProjectsManager projectsManager) {
		this.projectsManager = projectsManager;
		toolkit = new FormToolkit(parent.getDisplay());

		ScrolledComposite scrolledComposite = new ScrolledComposite(parent, SWT.V_SCROLL | SWT.H_SCROLL);
		scrolledComposite.setLayout(new FillLayout());
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);

		detailsForm = toolkit.createForm(scrolledComposite);
		scrolledComposite.setContent(detailsForm);

		detailsForm.setText("Filtering Option - No dataset selected");
		detailsForm.getBody().setLayout(new FillLayout());
		
		mainBody = toolkit.createComposite(scrolledComposite);
		mainBody.setLayout(new GridLayout(1, false));
		createMainBody();
		scrolledComposite.setContent(mainBody);
	}
	
	private void createMainBody() {
		Label label = new Label(mainBody, SWT.NONE);
		label.setText("Available Filters");
		
		tabFolder = new TabFolder(mainBody, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		// Create Node Filters tab
		TabItem nodesTab = new TabItem(tabFolder, SWT.NONE);
		nodesTab.setText("Nodes");
		Composite nodesComposite = new Composite(tabFolder, SWT.NONE);
		nodesComposite.setLayout(new GridLayout(1, false));
		nodesTab.setControl(nodesComposite);
		createNodeFiltersTab(nodesComposite);
		
		// Create Edge Filters tab
		TabItem edgesTab = new TabItem(tabFolder, SWT.NONE);
		edgesTab.setText("Edges");
		Composite edgesComposite = new Composite(tabFolder, SWT.NONE);
		edgesComposite.setLayout(new GridLayout(1, false));
		edgesTab.setControl(edgesComposite);
		createEdgeFiltersTab(edgesComposite);
	}
	
	private void createNodeFiltersTab(Composite parent) {
		Label nodeFiltersLabel = new Label(parent, SWT.NONE);
		nodeFiltersLabel.setText("Node filters");
		
		// TYPE
		Group typeGroup = new Group(parent, SWT.NONE);
		typeGroup.setText("Type");
		typeGroup.setLayout(new GridLayout(2, false));
		typeGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		// General
		toolkit.createLabel(typeGroup, "GENERAL");
		Button generalTypeBtn = toolkit.createButton(typeGroup, null, SWT.CHECK);
		
		
		// VARIABLE TYPE
		Group variableTypeGroup = new Group(parent, SWT.NONE);
		variableTypeGroup.setText("Variable Type");
		variableTypeGroup.setLayout(new GridLayout(2, false));
		variableTypeGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		// Discrete
		toolkit.createLabel(variableTypeGroup, "Discrete");
		Button discreteVarTypeBtn = toolkit.createButton(variableTypeGroup, null, SWT.CHECK);
		
		// Continuous
		toolkit.createLabel(variableTypeGroup, "Continuous");
		Button continuousVarTypeBtn = toolkit.createButton(variableTypeGroup, null, SWT.CHECK);
		
		
		// DISTRIBUTION
		Group distributionGroup = new Group(parent, SWT.NONE);
		distributionGroup.setText("Distribution");
		distributionGroup.setLayout(new GridLayout(2, false));
		distributionGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		// Normal
		toolkit.createLabel(distributionGroup, "NORMAL");
		Button normalDistributionBtn = toolkit.createButton(distributionGroup, null, SWT.CHECK);
		
		// Multinomial
		toolkit.createLabel(distributionGroup, "MULTINOMIAL");
		Button multinomialDistributionBtn = toolkit.createButton(distributionGroup, null, SWT.CHECK);
		
		// Poisson
		toolkit.createLabel(distributionGroup, "POISSON");
		Button poissonDistributionBtn = toolkit.createButton(distributionGroup, null, SWT.CHECK);
		
		// Gamma
		toolkit.createLabel(distributionGroup, "GAMMA");
		Button gammaDistributionBtn = toolkit.createButton(distributionGroup, null, SWT.CHECK);
		
		// NB
		toolkit.createLabel(distributionGroup, "NB");
		Button nbDistributionBtn = toolkit.createButton(distributionGroup, null, SWT.CHECK);
		
		
		// DATA TYPE
		Group dataTypeGroup = new Group(parent, SWT.NONE);
		dataTypeGroup.setText("Data Type");
		dataTypeGroup.setLayout(new GridLayout(2, false));
		dataTypeGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		// General
		toolkit.createLabel(dataTypeGroup, "General");
		Button generalDataTypeBtn = toolkit.createButton(dataTypeGroup, null, SWT.CHECK);
		
		// CLUSTER
		Group clusterGroup = new Group(parent, SWT.NONE);
		clusterGroup.setText("Cluster");
		clusterGroup.setLayout(new GridLayout(2, false));
		clusterGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
	}
	
	private void createEdgeFiltersTab(Composite parent) {
		Label edgeFiltersLabel = new Label(parent, SWT.NONE);
		edgeFiltersLabel.setText("Edge filters");
		
		// WEIGHT
		Group weightGroup = new Group(parent, SWT.NONE);
		weightGroup.setText("Weight Value");
		weightGroup.setLayout(new GridLayout(3, false));
		weightGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		toolkit.createLabel(weightGroup, "Weigth");
		Scale weightScale = new Scale(weightGroup, SWT.HORIZONTAL);
		weightScale.setMinimum(0);
		weightScale.setMaximum(100);
		weightScale.setSelection(50);
		weightScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label weightScaleValueLabel = toolkit.createLabel(weightGroup, "50");
		weightScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		
		// STRENGTH
		Group strengthGroup = new Group(parent, SWT.NONE);
		strengthGroup.setText("Strength Value");
		strengthGroup.setLayout(new GridLayout(3, false));
		strengthGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		toolkit.createLabel(strengthGroup, "Strength");
		Scale strengthScale = new Scale(strengthGroup, SWT.HORIZONTAL);
		strengthScale.setMinimum(0);
		strengthScale.setMaximum(100);
		strengthScale.setSelection(50);
		strengthScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label strengthScaleValueLabel = toolkit.createLabel(strengthGroup, "50");
		strengthScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		
		// PROPORTION
		Group proportionGroup = new Group(parent, SWT.NONE);
		proportionGroup.setText("Proportion Value");
		proportionGroup.setLayout(new GridLayout(3, false));
		proportionGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		toolkit.createLabel(proportionGroup, "Proportion");
		Scale proportionScale = new Scale(proportionGroup, SWT.HORIZONTAL);
		proportionScale.setMinimum(0);
		proportionScale.setMaximum(100);
		proportionScale.setSelection(50);
		proportionScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label proportionScaleValueLabel = toolkit.createLabel(proportionGroup, "50");
		proportionScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		
		// STRENGTH SCORE
		Group strengthScoreGroup = new Group(parent, SWT.NONE);
		strengthScoreGroup.setText("Strength Score Value");
		strengthScoreGroup.setLayout(new GridLayout(3, false));
		strengthScoreGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		toolkit.createLabel(strengthScoreGroup, "Strength Score");
		Scale strengthScoreScale = new Scale(strengthScoreGroup, SWT.HORIZONTAL);
		strengthScoreScale.setMinimum(0);
		strengthScoreScale.setMaximum(100);
		strengthScoreScale.setSelection(50);
		strengthScoreScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label strengthScoreScaleValueLabel = toolkit.createLabel(strengthScoreGroup, "50");
		strengthScoreScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		
		// P VALUES
		Group pValueGroup = new Group(parent, SWT.NONE);
		pValueGroup.setText("pValue Value");
		pValueGroup.setLayout(new GridLayout(3, false));
		pValueGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		toolkit.createLabel(pValueGroup, "pValue");
		Scale pValueScale = new Scale(pValueGroup, SWT.HORIZONTAL);
		pValueScale.setMinimum(0);
		pValueScale.setMaximum(100);
		pValueScale.setSelection(50);
		pValueScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label pValueScaleValueLabel = toolkit.createLabel(pValueGroup, "50");
		pValueScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		
		// P VALUE SCORE
		Group pValueScoreGroup = new Group(parent, SWT.NONE);
		pValueScoreGroup.setText("pValue Score Value");
		pValueScoreGroup.setLayout(new GridLayout(3, false));
		pValueScoreGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		toolkit.createLabel(pValueScoreGroup, "pValue Score");
		Scale pValueScoreScale = new Scale(pValueScoreGroup, SWT.HORIZONTAL);
		pValueScoreScale.setMinimum(0);
		pValueScoreScale.setMaximum(100);
		pValueScoreScale.setSelection(50);
		pValueScoreScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		Label pValueScoreScaleValueLabel = toolkit.createLabel(pValueScoreGroup, "50");
		pValueScoreScaleValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

		
	}

	// Methods to create UI for different dataset types
	private void createGeneralUI(Composite parent) {
		createDefaultUI(parent);
	}

	private void createCovariateUI(Composite parent) {
		createDefaultUI(parent);
	}

	private void createDefaultUI(Composite parent) {
		toolkit.createLabel(parent, "No filtering are applicable to this dataset type. Go To <a>Selection</a> view to select a Variables.");
	}
}
