package com.biotechvana.netools.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataLayer;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.grid.GridRegion;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.DefaultNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommand;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.biotechvana.netools.IEdgesView;
import com.biotechvana.netools.INetworkView;
import com.biotechvana.netools.ISelectionEvent;
import com.biotechvana.netools.ISelectionListener;
import com.biotechvana.netools.ISelectionManager;
import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.NetworkModel;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

import ca.odell.glazedlists.*;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;

public class EdgesViewer implements IEdgesView{
	public static final Logger logger = LoggerFactory.getLogger(EdgesViewer.class);

	private SelectionLayer selectionLayer;
	private ViewportLayer viewportLayer;

	class EdgesColumnPropertyAccessor implements IColumnPropertyAccessor<Edge> {

		String[] edgesModel;
		NetworkModel network;
		Map<String, Integer> columnIndexes = new HashMap<>();
		public EdgesColumnPropertyAccessor(String[] edgesModel, NetworkModel network) {
			this.edgesModel = edgesModel;
			this.network = network;
			for (int i = 0; i < edgesModel.length; i++) {
				columnIndexes.put(edgesModel[i], i);
			}

		}

		@Override
		public Object getDataValue(Edge rowObject, int columnIndex) {
			String property = edgesModel[columnIndex];
			if (property.equals("id"))
				return rowObject.getId();
			if (property.equals("label")) {
				String label = rowObject.getLabel();
				// if empty
				if (label == null || label.isEmpty()) {
					label = rowObject.getSource() + " -> " + rowObject.getTarget();
				}
				return label;
			}
			if (property.equals("source")) {
				return rowObject.getSource();
			}
			if (property.equals("target")) {
				return rowObject.getTarget();
			}
			if (property.equals("weight")) {
				return rowObject.getWeight();
			}

			Object value = rowObject.getAttribute(property);
//			if (value instanceof String && property.equals("proportion")) {
//				double double_value = Double.parseDouble((String) value);
//				value = double_value;
//			} 
			return value;

		}

		@Override
		public void setDataValue(Edge rowObject, int columnIndex, Object newValue) {
			String property = edgesModel[columnIndex];


		}

		@Override
		public int getColumnCount() {

			return edgesModel.length;
		}

		@Override
		public String getColumnProperty(int columnIndex) {

			return  edgesModel[columnIndex];
		}

		@Override
		public int getColumnIndex(String propertyName) {
			return columnIndexes.get(propertyName);
		}

	}



	class EdgeDataProvider extends ListDataProvider<Edge> {

		public EdgeDataProvider(List<Edge> list, IColumnAccessor<Edge> columnAccessor) {
			super(list, columnAccessor);
			// TODO Auto-generated constructor stub
		}

	}


	public class PositionCoordinate {
		public final int row;
		public final int col;

		public PositionCoordinate(int row, int col) {
			this.row = row;
			this.col = col;
		}
	}

	/**
	 * Always encapsulate the body layer stack in an AbstractLayerTransform to
	 * ensure that the index transformations are performed in later commands.
	 *
	 * @param <T>
	 */
	class BodyLayerStack<T> extends AbstractLayerTransform {
		private final FilterList<T> filterList;
		private final IDataProvider bodyDataProvider;
		private final SelectionLayer selectionLayer;
		private final  ViewportLayer viewportLayer;
		public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor) {
			// wrapping of the list to show into GlazedLists
			// see http://publicobject.com/glazedlists/ for further information
			EventList<T> eventList = GlazedLists.eventList(values);
			TransformedList<T, T> rowObjectsGlazedList = GlazedLists.threadSafeList(eventList);
			// use the SortedList constructor with 'null' for the Comparator
			// because the Comparator will be set by configuration
			SortedList<T> sortedList = new SortedList<>(rowObjectsGlazedList, null);
			// wrap the SortedList with the FilterList
			this.filterList = new FilterList<>(sortedList);
			this.bodyDataProvider =
					new ListDataProvider<>(this.filterList, columnPropertyAccessor);
			DataLayer bodyDataLayer =
					new DataLayer(getBodyDataProvider());
			bodyDataLayer.setConfigLabelAccumulator(new ColumnLabelAccumulator());
			
			// This is to make only the id column selectable
			bodyDataLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator() {
				@Override
			    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
			        int columnIndex = bodyDataLayer.getColumnIndexByPosition(columnPosition);
			        configLabels.addLabel("NON_SELECTABLE_COLUMN");			        
			        /*if (columnIndex == 0) {
			            configLabels.addLabel("SELECTABLE_COLUMN");
			        } else {
			            configLabels.addLabel("NON_SELECTABLE_COLUMN");
			        }*/
			    }
			});
			
			// layer for event handling of GlazedLists and PropertyChanges
			GlazedListsEventLayer<T> glazedListsEventLayer =
					new GlazedListsEventLayer<>(bodyDataLayer, this.filterList);
			this.selectionLayer = new SelectionLayer(glazedListsEventLayer);
			viewportLayer = new ViewportLayer(getSelectionLayer());
			setUnderlyingLayer(viewportLayer);
		}
		public SelectionLayer getSelectionLayer() {
			return this.selectionLayer;
		}
		public FilterList<T> getFilterList() {
			return this.filterList;
		}
		public IDataProvider getBodyDataProvider() {
			return this.bodyDataProvider;
		}

		public ViewportLayer getViewportLayer() {
			return this.viewportLayer;
		}
	}

	public class ColumnHeaderLayerStack extends AbstractLayerTransform {
		DataLayer columnHeaderDataLayer;
		public ColumnHeaderLayerStack(IDataProvider columnHeaderDataProvider, BodyLayerStack bodyLayerStack) {
			columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(columnHeaderDataProvider);
			ColumnHeaderLayer columnHeaderLayer = 
					new ColumnHeaderLayer(columnHeaderDataLayer,
							bodyLayerStack, bodyLayerStack.getSelectionLayer());
			setUnderlyingLayer(columnHeaderLayer);
		}

		public DataLayer getDataLayer() {
			return columnHeaderDataLayer;
		}
	}

	//	public class RowHeaderLayerStack extends AbstractLayerTransform {
	//
	//        public RowHeaderLayerStack(IDataProvider dataProvider , BodyLayerStack bodyLayer) {
	//            DataLayer dataLayer = new DataLayer(dataProvider, 50, 20);
	//            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer(dataLayer,
	//                    bodyLayer, bodyLayer.getSelectionLayer());
	//            setUnderlyingLayer(rowHeaderLayer);
	//        }
	//    }

	public class CustomStyleTheme implements IThemeExtension {

		@Override
		public void registerStyles(IConfigRegistry configRegistry) {
			Style customStyle = new Style();
			customStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, GUIHelper.COLOR_YELLOW);
			customStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, GUIHelper.COLOR_BLACK);

			configRegistry.registerConfigAttribute(
					CellConfigAttributes.CELL_STYLE,
					customStyle,
					DisplayMode.SELECT);
		}

		@Override
		public void unregisterStyles(IConfigRegistry configRegistry) {
			configRegistry.unregisterConfigAttribute(
					CellConfigAttributes.CELL_STYLE,
					DisplayMode.SELECT);
		}
	}

	IDataProvider bodyDataProvider;
	static String[] propertyTypes;
	class FilterRowCustomConfiguration extends AbstractRegistryConfiguration {

		DefaultDoubleDisplayConverter doubleDisplayConverter = new DefaultDoubleDisplayConverter();


		public void configureRegistry(IConfigRegistry configRegistry) {

			// override the default filter row configuration for painter
			            configRegistry.registerConfigAttribute(
			                    CellConfigAttributes.CELL_PAINTER,
			                    new FilterRowPainter(
			                            new FilterIconPainter(GUIHelper.getImage("filter"))),
			                    DisplayMode.NORMAL,
			                    GridRegion.FILTER_ROW);



			int columnCount = EdgesViewer.this.bodyDataProvider.getColumnCount();
			for (int colIndex = 0; colIndex < columnCount; colIndex++) {
				if (propertyTypes[colIndex] != null) {
					if (propertyTypes[colIndex].equals(NetworkModel.MODEL_TYPE_STRING)) {
						// STANDARD STRING FILTER
						configRegistry.registerConfigAttribute(
								FilterRowConfigAttributes.FILTER_COMPARATOR,
								getIgnoreCaseComparator(),
								DisplayMode.NORMAL,
								FilterRowDataLayer.FILTER_ROW_COLUMN_LABEL_PREFIX + colIndex);
						
					} else if (propertyTypes[colIndex].equals(NetworkModel.MODEL_TYPE_DOUBLE)) {
						// NUMERIC COMPARISON FILTER
						configRegistry.registerConfigAttribute(
								FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER,
								doubleDisplayConverter,
								DisplayMode.NORMAL,
								FilterRowDataLayer.FILTER_ROW_COLUMN_LABEL_PREFIX + colIndex);
						configRegistry.registerConfigAttribute(
								FilterRowConfigAttributes.TEXT_MATCHING_MODE,
								TextMatchingMode.REGULAR_EXPRESSION,
								DisplayMode.NORMAL,
								FilterRowDataLayer.FILTER_ROW_COLUMN_LABEL_PREFIX + colIndex);
						
					} else if (propertyTypes[colIndex].equals(NetworkModel.MODEL_TYPE_BOOLEAN)) {
						// BOOLEAN FILTER
						configRegistry.registerConfigAttribute(
								EditConfigAttributes.CELL_EDITOR,
								new ComboBoxCellEditor(Arrays.asList("False", "True")),
								DisplayMode.NORMAL,
								FilterRowDataLayer.FILTER_ROW_COLUMN_LABEL_PREFIX + colIndex);
						
					}

				}

			}

			final Style rowStyle = new Style();
			rowStyle.setAttributeValue(
					CellStyleAttributes.BACKGROUND_COLOR,
					GUIHelper.getColor(197, 212, 231));
			configRegistry.registerConfigAttribute(
					CellConfigAttributes.CELL_STYLE,
					rowStyle,
					DisplayMode.NORMAL,
					GridRegion.FILTER_ROW);
		}

	}

	private static Comparator<String> getIgnoreCaseComparator() {
		return new Comparator<String>() {
			@Override
			public int compare(String o1, String o2) {
				return o1.compareToIgnoreCase(o2);
			}
		};
	};


	@Inject
	UISynchronize sync;
	Project activeProject;
	IProjectsManager projectsManager;

	@Inject
	IProgressService progressService;

	NetworkModel network;

	INetworkView networkViewer;


	@Inject
	@Optional 
	public void setActiveProject(@Named(IProjectsManager.ACTIVE_PROJECT) Project project) {
		activeProject = project;

	}

	@Inject
	private void setNetworkModel(@Optional NetworkModel network) {
		this.network = network;
		logger.debug("EdgesViewer.setNetworkModel");
		sync.asyncExec(() -> {
			if (mainBody != null && !mainBody.isDisposed()) {
				createTableViewer(mainBody);
			}
		});
		
	}

	@Inject
	public void setNetworkViewer(@Optional INetworkView networkViewer) {
		this.networkViewer = networkViewer;
	}

	ISelectionManager selectionManager;

	ISelectionListener currentSelectionListener;

	@Inject  
	public void setSelectionManager(@Optional ISelectionManager selectionManager) {

		if (this.selectionManager != null && currentSelectionListener != null) {
			this.selectionManager.removeSelectionListener(currentSelectionListener);
		}

		if (selectionManager == null) {
			this.selectionManager = null;
			return;
		}


		this.selectionManager = selectionManager;
		if (currentSelectionListener == null) {
			currentSelectionListener = new ISelectionListener() {

				@Override
				public void nodesSelectionChanged(ISelectionEvent event) {
					// TODO Auto-generated method stub

				}

				@Override
				public void edgesSelectionChanged(ISelectionEvent event) {
					// TODO Auto-generated method stub
					// handle selection change event here
					if(EdgesViewer.this.doNotUpdateSelectionInTable)
					{
						EdgesViewer.this.doNotUpdateSelectionInTable = false;
						return;
					}
					System.out.println("Edge Selection Changed Edges Viewer");
					System.out.println(event);
					selectedEdgesString.clear();
					selectedEdges = event.getSelectedEdges();
					for (Edge edge : selectedEdges) {
						String edgeId = edge.getId();
						selectedEdgesString.add(edgeId);
					}
					doNotUpdateSelectionInViewer=true;
					selectEdgesInTable(selectedEdgesString);
					doNotUpdateSelectionInViewer=false;
				}
			};
		}

		this.selectionManager.addSelectionListener(currentSelectionListener);
	}


	Composite mainBody;
	Composite tableComposite;

	@PostConstruct
	public void createPartControl(Composite parent, MApplication app, IProjectsManager projectsManager) { 
		this.projectsManager = projectsManager;
		app.getContext().set(IEdgesView.class, this);
		logger.debug("EdgesViewer.createPartControl");
		mainBody = new Composite(parent, SWT.NONE);
		mainBody.setLayout(new FillLayout());
		createTableViewer(mainBody); 
	}

	private void createTableViewer(Composite parent) {
		logger.debug("EdgesViewer.createTableViewer");
		if (tableComposite != null && !tableComposite.isDisposed()) {
			tableComposite.dispose();
		}
		tableComposite = new Composite(parent, SWT.NONE);
		tableComposite.setLayout(new GridLayout());
		createNatTable(tableComposite);
	}


	Set<Edge> selectedEdges = new HashSet<>();
	Set<String> selectedEdgesString = new HashSet<>();
	Map<PositionCoordinate, String> edgeTablePositions = new HashMap<>();

	NatTable natTable;

	private void createNatTable(Composite tableComposite2) {
		if (network == null) {
			return;
		}

		IConfigRegistry configRegistry = new ConfigRegistry();
		List<Edge> edgeList =  List.copyOf(network.getEdges());

		// UNDERLYING DATA SOURCE
		// EventList<Edge> eventList = GlazedLists.eventList(edgeList);
		//		FilterList<Edge> filterList = new FilterList<Edge>(eventList);

		String[] propertyNames = network.getEdgedModel();
		propertyTypes = network.getEdgedModelType();

		List<String> modelHeader = new ArrayList<>() ;
		// fill the model header from property names
		for (String p : propertyNames) {
			modelHeader.add(p);
		}
		Map<String, String> propertyToLabels = modelHeader.stream().collect(Collectors.toMap(h -> h, h -> {
			String label = h;
			// set first letter to upper case
			label = label.substring(0, 1).toUpperCase() + label.substring(1);
			return label;
		}));


		// BODY LAYER
		IColumnPropertyAccessor<Edge> columnPropertyAccessor = new EdgesColumnPropertyAccessor(propertyNames, network);

		BodyLayerStack<Edge> bodyLayerStack = new BodyLayerStack<Edge>(edgeList, columnPropertyAccessor);
		this.bodyDataProvider = bodyLayerStack.getBodyDataProvider();
		this.selectionLayer = bodyLayerStack.getSelectionLayer();
		this.viewportLayer = bodyLayerStack.getViewportLayer();

		// COLUMN HEADER LAYER
		DefaultColumnHeaderDataProvider columnHeaderDataProvider = 
				new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabels);
		ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack(columnHeaderDataProvider, bodyLayerStack);

		// Note: The column header layer is wrapped in a filter row composite.
		// This plugs in the filter row functionality

		FilterRowHeaderComposite<Edge> filterRowHeaderLayer =
				new FilterRowHeaderComposite<>(
						new DefaultGlazedListsFilterStrategy<>(
								bodyLayerStack.getFilterList(),
								columnPropertyAccessor,
								configRegistry),
						columnHeaderLayer,
						// columnHeaderDataLayer in columnHeaderLayerStack
						columnHeaderLayer.getDataLayer().getDataProvider(),
						configRegistry);

		// build the row header layer
		IDataProvider rowHeaderDataProvider =
				new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
		DataLayer rowHeaderDataLayer =
				new DefaultRowHeaderDataLayer(rowHeaderDataProvider);
		ILayer rowHeaderLayer =
				new RowHeaderLayer(
						rowHeaderDataLayer,
						bodyLayerStack,
						bodyLayerStack.getSelectionLayer());
		// build the corner layer
		IDataProvider cornerDataProvider =
				new DefaultCornerDataProvider(columnHeaderDataProvider, rowHeaderDataProvider);
		DataLayer cornerDataLayer =
				new DataLayer(cornerDataProvider);
		ILayer cornerLayer =
				new CornerLayer(cornerDataLayer, rowHeaderLayer, filterRowHeaderLayer);
		// build the grid layer
		GridLayer gridLayer =
				new GridLayer(bodyLayerStack, filterRowHeaderLayer, rowHeaderLayer, cornerLayer);
		// turn the auto configuration off as we want to add our header menu
		// configuration

		natTable = new NatTable(tableComposite2, gridLayer, false); // false to disable autoconfigure
		natTable.setConfigRegistry(configRegistry);
		GridDataFactory.fillDefaults().grab(true, true).applyTo(natTable);
		natTable.addOverlayPainter(new NatTableBorderOverlayPainter(natTable.getConfigRegistry()));

		// custom cell style configuration
		final ThemeConfiguration defaultTheme = new DefaultNatTableThemeConfiguration();
		 defaultTheme.addThemeExtension(new CustomStyleTheme());

		// add filter row configuration
		natTable.addConfiguration(new FilterRowCustomConfiguration() );

		// make only id column selectable
		natTable.addConfiguration(new AbstractUiBindingConfiguration() {
		    @Override
		    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
		        uiBindingRegistry.registerFirstMouseDownBinding(
		            new MouseEventMatcher(SWT.NONE, GridRegion.BODY, MouseEventMatcher.LEFT_BUTTON),
		            new IMouseAction() {
		                @Override
		                public void run(NatTable natTable, MouseEvent event) {
		                    int columnPosition = natTable.getColumnPositionByX(event.x);
		                    int rowPosition = natTable.getRowPositionByY(event.y);
		                    LabelStack labels = natTable.getConfigLabelsByPosition(columnPosition, rowPosition);

		                    if (labels.hasLabel("SELECTABLE_COLUMN")) {
		                        natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition, false, false));
		                    }
		                    // In other columns, ignore click
		                }
		            });
		    }
		});
		
		natTable.configure();
		natTable.setTheme(defaultTheme);

		mainBody.layout(true);

		//chargeDataTable(bodyDataProvider);


		// REACTIVITY PART
		natTable.addLayerListener(new ILayerListener() {
			@Override
			public void handleLayerEvent(ILayerEvent event) {
				chargeDataTable(bodyDataProvider);
				//if (selectingRows) return;
				if (event instanceof CellSelectionEvent) { // INDIVIDUAL CELLS SELECTION
					CellSelectionEvent cellEvent = (CellSelectionEvent) event;

					int row = cellEvent.getRowPosition();
					int col = cellEvent.getColumnPosition();

					Object cellData = natTable.getDataValueByPosition(col, row);
					System.out.println("Selected cell: [" + row + ", " + col + "], " + cellData);		 

					org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
					updateSelectedEdgesFromTable(selectedCells, edgeTablePositions, selectedEdgesString);


				} else if (event instanceof ColumnSelectionEvent) {  // ENTIRE COLUMN SELECTION
					ColumnSelectionEvent columnEvent = (ColumnSelectionEvent) event;
					Collection<Range> entireColumn = columnEvent.getColumnPositionRanges();
					System.out.println("Selected Column: " + entireColumn);

					org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
					updateSelectedEdgesFromTable(selectedCells, edgeTablePositions, selectedEdgesString);

				} else if (event instanceof RowSelectionEvent) { // ENTIRE ROW SELECTION
					RowSelectionEvent rowEvent = (RowSelectionEvent) event;
					Collection<Range> entireRow = rowEvent.getRowPositionRanges();
					System.out.println("Selected Row: " + entireRow);
					
					org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
					//if (prevSelectedCells == null || !Arrays.equals(prevSelectedCells, selectedCells)) {
					//	prevSelectedCells = selectedCells;
						updateSelectedEdgesFromTable(selectedCells, edgeTablePositions, selectedEdgesString);
					//}
					//prevSelectedCells = selectedCells;
				
				}

			}
		});
	}

	boolean doNotUpdateSelectionInTable = false;
	boolean doNotUpdateSelectionInViewer = false;
	private void updateSelectedEdgesFromTable(org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate[] selectedCells, Map<PositionCoordinate, String> edgeTablePositions, Set<String> selectedEdges) {
		if (doNotUpdateSelectionInViewer)
		{
			return;
		}
		selectedEdges.clear();

		for (org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate cell : selectedCells) {
			int col = cell.columnPosition;
			int row = cell.rowPosition;

			if (col == 0) {
				for (Map.Entry<PositionCoordinate, String> entry : edgeTablePositions.entrySet()) {
					PositionCoordinate edgePos = entry.getKey();
					if (edgePos.row == row && edgePos.col == col) {
						selectedEdges.add(entry.getValue());
						break;
					}
				}
			}
		}
		this.doNotUpdateSelectionInTable=true;
		networkViewer.setEdgeSelection(selectedEdges);
	}

	boolean selectingRows = false;
	boolean isRowVisible = false;
	@Override
	public void selectEdgesInTable(Set<String> edges) {
		PositionCoordinate coord = null;
		selectingRows = true;
		selectionLayer.clear();

		for (String edge: edges) {
			for (Map.Entry<PositionCoordinate, String> entry : edgeTablePositions.entrySet()) {
				String edgeCellValue = entry.getValue();
				if (edge.equals(edgeCellValue)) {
					coord = entry.getKey();
					break;
				}
			}

			if (coord != null) {
				int rowIndex = coord.row+1;
				int rowCount = viewportLayer.getRowCount();
				int firstVisibleRow = viewportLayer.getRowIndexByPosition(0);
				int lastVisibleRow = rowCount + firstVisibleRow;

				if (!isRowVisible(rowIndex, firstVisibleRow, lastVisibleRow)) {
					natTable.doCommand(new ShowRowInViewportCommand(coord.row));
					firstVisibleRow = viewportLayer.getRowIndexByPosition(0);
					lastVisibleRow = rowCount + firstVisibleRow;
				}

				int rowDiference = Math.abs(lastVisibleRow - rowIndex);

				int rowPosition = selectionLayer.getRowPositionByIndex(rowCount - rowDiference);
				if (!selectionLayer.isRowPositionSelected(rowIndex-1)) {
					selectionLayer.doCommand(new SelectRowsCommand(natTable, 1, rowPosition+1, false, true));
				}
				selectingRows = false;
			}
		}
	}

	private void chargeDataTable(IDataProvider bodyDataProvider) {
		int totalRows = bodyDataProvider.getRowCount();
		int totalCols = bodyDataProvider.getColumnCount();
		edgeTablePositions.clear();
		
		for (int col = 0; col < 1; col++) { // only id, (label, source and target)
			for (int row = 0; row < totalRows; row++) {
				Object cellData = bodyDataProvider.getDataValue(col, row);
				if(cellData != null)
					edgeTablePositions.put(new PositionCoordinate(row, col), cellData.toString());
			}
		}
	}

	public boolean isRowVisible(int rowIndex, int firstVisibleRow, int lastVisibleRow) {
		return rowIndex >= firstVisibleRow && rowIndex <= lastVisibleRow;
	}

}
