/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class FTPPasteAction {
    public static final String TITLE = "Paste";
    IRemoteFile destination = null;

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager) {
        return ftpManager.isConnected();
    }

    @Execute
    public void run(final FTPViewerComponent ftpViewer) {
        IRemoteFile[] selection = ftpViewer.getSelectedFiles();
        if (selection != null && selection.length != 0) {
            this.destination = selection[0];
        }
        if (this.destination == null) {
            this.destination = ftpViewer.getFtpManager().getWorkingDirectory();
        }
        if (ftpViewer.clipboard == null) {
            return;
        }
        Job pasteJob = new Job("Paste (" + Integer.toString(ftpViewer.clipboard.selection.length) + ") files/folders"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IRemoteFile[] selection_files = ftpViewer.clipboard.selection;
                    monitor.beginTask("Pasting files", -1);
                    IRemoteFile[] iRemoteFileArray = ftpViewer.clipboard.selection;
                    int n = ftpViewer.clipboard.selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRemoteFile file = iRemoteFileArray[n2];
                        String uri = file.getURI();
                        monitor.subTask("Pasting " + file.getName());
                        ftpViewer.getFtpManager().paste(uri, FTPPasteAction.this.destination.getURI(), ftpViewer.clipboard.mode == FTPViewerComponent.ClipboardMode.CUT);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n2;
                    }
                    try {
                        ftpViewer.updateFTPList();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        pasteJob.setUser(true);
        pasteJob.schedule();
    }
}

