/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FTPNewFolderAction {
    public static final String TITLE = "New folder";

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager) {
        return ftpManager.isConnected();
    }

    @Execute
    public void run(FTPViewerComponent ftpViewer) {
        InputDialog dialog = new InputDialog(ftpViewer.getShell(), TITLE, "Enter folder name", "New_folder", null);
        int res = dialog.open();
        if (res == 1) {
            return;
        }
        String value = dialog.getValue();
        if (value.isEmpty()) {
            return;
        }
        value = value.replaceAll("\\s+", "_");
        value = value.replaceAll("\\(|\\)|\\[|\\|\\\\|/", "");
        if (!ftpViewer.getFtpManager().createFolder(value)) {
            MessageDialog.openError((Shell)ftpViewer.getShell(), (String)"FTP", (String)"Failed creating folder");
        }
        try {
            ftpViewer.updateFTPList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

