/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.IFileTransferService;
import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import java.util.ArrayList;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class FTPDownloadAction {
    public static final String TITLE = "Download";

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager) {
        return ftpManager.isConnected();
    }

    @Execute
    public void run(FTPViewerComponent ftpViewer, IFileTransferService fileTransferService) {
        IRemoteFile[] selection = ftpViewer.getSelectedFiles();
        if (selection == null) {
            return;
        }
        if (selection.length > 0) {
            ArrayList<String> selectedPaths = new ArrayList<String>();
            int i = 0;
            while (i < selection.length) {
                IRemoteFile selected = selection[i];
                if (!selected.isParent() && !selected.isCWD()) {
                    selectedPaths.add(selected.getPath());
                }
                ++i;
            }
            fileTransferService.downloadFiles(selectedPaths, null);
        }
    }
}

