/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.model.ServiceStatus;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.servercommons.dialogs.preferences.DockerHelper;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class GPROUserManager
extends UserManager {
    @Inject
    IFTPManager ftpManager;

    protected void postLoginHandle() throws IOException {
        try {
            String userName = this.activeLogin.getUserName();
            Object host = this.activeLogin.getHostInfo().getServerURL();
            int sshPort = this.activeLogin.getHostInfo().getSshPort();
            int ftpPort = this.activeLogin.getHostInfo().getFtpPort();
            int httpPort = this.activeLogin.getHostInfo().getHttpPort();
            String password = this.activeLogin.getPassword();
            String scheme = this.activeLogin.getHostInfo().getScheme();
            if (httpPort != 80) {
                host = (String)host + ":" + httpPort;
            }
            GPROUserManager.fetchDatabaseSettings((UserManager)this, (String)host, (String)userName, (String)PipelineCommander.md5Hash((String)password));
        }
        catch (Exception e) {
            throw new IOException("Error: cannot fetch database connection settings");
        }
    }

    public List<ServiceStatus> getCheckStatus(final UserLoginInfo userLogin) {
        ArrayList<ServiceStatus> services = new ArrayList<ServiceStatus>();
        if (this.get("USE_LOCAL_GPRO_PROP", "false").equals("true")) {
            services.add(new ServiceStatus(){
                {
                    this.name = "Docker Service";
                }

                public boolean runCheck() {
                    return DockerHelper.checkStart(null, false);
                }
            });
        } else {
            services.add(new ServiceStatus(){
                {
                    this.name = "Remote Server Check";
                }

                public boolean runCheck() {
                    return GPROUserManager.this.serverIsAvailable(userLogin);
                }
            });
        }
        services.add(new ServiceStatus(){
            {
                this.name = "sftp Service";
            }

            public boolean runCheck() {
                String userName = userLogin.getUserName();
                String host = userLogin.getHostInfo().getServerURL();
                int ftpPort = userLogin.getHostInfo().getSshPort();
                String password = userLogin.getPassword();
                String scheme = userLogin.getHostInfo().getScheme();
                return GPROUserManager.this.ftpManager.testConnection(scheme, userName, password, host, ftpPort);
            }
        });
        services.add(new ServiceStatus(){
            {
                this.name = "Server API LOGIN";
            }

            public boolean runCheck() {
                return GPROUserManager.this.testAPILogin(userLogin);
            }
        });
        services.add(new ServiceStatus(){
            {
                this.name = "DB Connections";
            }

            public boolean runCheck() {
                try {
                    String userName = userLogin.getUserName();
                    Object host = userLogin.getHostInfo().getServerURL();
                    int sshPort = userLogin.getHostInfo().getSshPort();
                    int ftpPort = userLogin.getHostInfo().getFtpPort();
                    int httpPort = userLogin.getHostInfo().getHttpPort();
                    String password = userLogin.getPassword();
                    String scheme = userLogin.getHostInfo().getScheme();
                    if (httpPort != 80) {
                        host = (String)host + ":" + httpPort;
                    }
                    GPROUserManager.fetchDatabaseSettings((UserManager)GPROUserManager.this, (String)host, (String)userName, (String)PipelineCommander.md5Hash((String)password));
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        return services;
    }

    private boolean serverIsAvailable(UserLoginInfo userLogin) {
        Object remoteHost;
        block7: {
            block6: {
                if (userLogin != null) break block6;
                return false;
            }
            remoteHost = userLogin.getHostInfo().getServerURL();
            if (remoteHost != null && !((String)remoteHost).trim().isEmpty()) break block7;
            return false;
        }
        try {
            if (!((String)remoteHost).startsWith("http://")) {
                remoteHost = "http://" + (String)remoteHost;
            }
            URL url = new URL((String)remoteHost);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            return true;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testAPILogin(UserLoginInfo userLogin) {
        try {
            String token;
            String userName = userLogin.getUserName();
            String host = userLogin.getHostInfo().getServerURL();
            int httpPort = userLogin.getHostInfo().getHttpPort();
            String password = userLogin.getPassword();
            if (httpPort == 0) {
                httpPort = 80;
            }
            PipelineCommander pc = new PipelineCommander(host, httpPort, (IPrefs)this);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter output = new OutputStreamWriter(baos);
            pc.prepareCommandRequest(userName, password, "ls -l", true, null, false);
            pc.postPipelineRequest((Writer)output);
            String response = baos.toString();
            System.out.println("Response: " + response);
            if (response == null || response.length() == 0) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(response, "\n");
            do {
                if (tokenizer.hasMoreTokens()) continue;
                return false;
            } while (!(token = tokenizer.nextToken()).trim().contains("SSH authentication valid"));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public IFTPManager getFTPManager() {
        return this.ftpManager;
    }

    protected void chechIfRooted() {
        try {
            this.ischRooted = true;
            this.ischRooted = this.ftpManager.isChRooted();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

