/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.ftpqueue;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferType;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class DoneTransfersView {
    private TableViewer doneViewer;
    List<IFtpFileTransfer> doneFileList;

    public void createPartControl(Composite parent) {
        this.doneViewer = new TableViewer(parent, 2816);
        this.doneViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn doneColSize = new TableViewerColumn(this.doneViewer, 0);
        doneColSize.getColumn().setWidth(200);
        doneColSize.getColumn().setText("Size");
        doneColSize.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return FileUtils.byteCountToDisplaySize((long)file.getTotalSize());
            }
        });
        TableViewerColumn doneColStatus = new TableViewerColumn(this.doneViewer, 0);
        doneColStatus.getColumn().setWidth(200);
        doneColStatus.getColumn().setText("Status");
        doneColStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return file.getStatus().toString();
            }
        });
        TableViewerColumn doneColFile = new TableViewerColumn(this.doneViewer, 0);
        doneColFile.getColumn().setWidth(200);
        doneColFile.getColumn().setText("File");
        doneColFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return file.getSourcePath();
            }

            public Image getImage(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                if (file.getTransferType() == TransferType.DOWNLOAD) {
                    return SharedImages.ARROWDOWN;
                }
                return SharedImages.ARROWUP;
            }
        });
        Table table = this.doneViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public Control getControl() {
        return this.doneViewer.getControl();
    }

    public void setInput(List<IFtpFileTransfer> doneFileList) {
        this.doneFileList = doneFileList;
        this.doneViewer.setInput(this.doneFileList);
    }

    public void updateUI() {
        this.doneViewer.refresh();
    }
}

