/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class JobVariableComposite
extends VariableComposite {
    private static final String CONS_FIELD_TYPE_PREFIX = "Field Type : ";
    boolean loopBack = false;

    protected JobVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable var, int istyle) {
        super(parent, parentJobComposite, var, istyle);
    }

    @Override
    protected void createContolsPart() {
        super.createContolsPart();
        if (this.var.getDescGUIVisible()) {
            GridData layoutData;
            VariableDescriptor.VariableType varType = this.var.getDescVarType();
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                int varDesclabelHSpan = 1;
                this.varDesclabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(1, 0x1000000, false, false, varDesclabelHSpan, 1);
                layoutData.minimumWidth = 50;
                layoutData.widthHint = 400;
                this.varDesclabel.setLayoutData((Object)layoutData);
                if (this.parentJobComposite.supportShowHelp()) {
                    this.varDesclabel.setText(this.var.getDescFriendlyName() + " : !");
                    this.varDesclabel.setToolTipText("Double Click! to Show more help.");
                } else {
                    this.varDesclabel.setText(this.var.getDescFriendlyName());
                    if (this.var.getDescHelpMsg() != null) {
                        this.varDesclabel.setToolTipText(this.var.getDescHelpMsg());
                    }
                }
                FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
                fontdata.setStyle(1);
                Font font = new Font((Device)this.getDisplay(), fontdata);
                this.varDesclabel.setFont(font);
            }
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                Object cmdParamater;
                Link varErrorslabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(4, 1, true, false, 2, 2);
                layoutData.widthHint = 300;
                layoutData.horizontalIndent = 10;
                varErrorslabel.setLayoutData((Object)layoutData);
                this.disposableParts.add(varErrorslabel);
                String helpMsg = this.var.getDescHelpMsg();
                if (helpMsg == null) {
                    helpMsg = "";
                }
                if (!((String)(cmdParamater = this.var.getDescCommandParamater().trim())).isEmpty()) {
                    cmdParamater = "(" + (String)cmdParamater;
                    String alt = this.var.getDescCommandParamaterAlt().trim();
                    if (!alt.isEmpty()) {
                        cmdParamater = (String)cmdParamater + "/" + alt;
                    }
                    cmdParamater = (String)cmdParamater + ") ";
                }
                this.helpMsg = (String)cmdParamater + helpMsg;
                this.varHelplabel = varErrorslabel;
                this.helpMsg = this.var.getDescHelpMsg();
            }
            if (varType == VariableDescriptor.VariableType.File || varType == VariableDescriptor.VariableType.Folder) {
                final Text varValueText = new Text((Composite)this, 2060);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                layoutData.horizontalIndent = 25;
                layoutData.widthHint = 500;
                varValueText.setLayoutData((Object)layoutData);
                varValueText.setToolTipText(this.var.getDescHelpMsg());
                this.controlDecoration = new ControlDecoration((Control)varValueText, 0x1004000);
                this.controlDecoration.setDescriptionText("");
                this.controlDecoration.hide();
                ControlDecoration c = new ControlDecoration((Control)varValueText, 0x1020000);
                if (varType == VariableDescriptor.VariableType.File) {
                    c.setImage(SharedImages.FILE);
                    c.setDescriptionText("Field Type : File");
                }
                if (varType == VariableDescriptor.VariableType.Folder) {
                    c.setImage(SharedImages.FOLDER);
                    c.setDescriptionText("Field Type : Folder");
                }
                c.setShowOnlyOnFocus(true);
                KeyListener clearSet = new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        if ((e.keyCode == 27 || e.keyCode == 8 || e.keyCode == 127) && e.getSource() instanceof Text) {
                            JobVariableComposite.this.var.setValue("");
                        }
                    }
                };
                varValueText.addKeyListener(clearSet);
                String value = this.var.getValue();
                if (value != null) {
                    varValueText.setText(this.var.getValue());
                }
                varValueText.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        JobVariableComposite.this.var.setValue(varValueText.getText());
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
                int dropManagerType = -1;
                switch (varType) {
                    case File: {
                        dropManagerType = 3;
                        break;
                    }
                    case Folder: {
                        dropManagerType = 4;
                    }
                }
                if (dropManagerType != -1) {
                    try {
                        String userName = this.parentJobComposite.getUserManager().getUserLoginInfo().getUserName();
                        String hostName = this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getServerURL();
                        String password = this.parentJobComposite.getUserManager().getUserLoginInfo().getPassword();
                        String ftpPort = "" + this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getFtpPort();
                        this.dropManager = DropManager.create((Control)varValueText, (int)2, (int)dropManagerType);
                    }
                    catch (InvalidLoginInfoException e1) {
                        e1.printStackTrace();
                    }
                }
                this.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        JobVariableComposite.this.loopBack = true;
                        varValueText.setText(JobVariableComposite.this.var.getValue());
                    }
                });
                this.varControl = varValueText;
            }
            String shortMsg = "Drag a folder from the FTP Browser";
            if (varType == VariableDescriptor.VariableType.File) {
                shortMsg = "Drag a file from the FTP Browser";
            }
            if (this.var.getDescShortHelpMsg() != null && !this.var.getDescShortHelpMsg().isEmpty()) {
                shortMsg = this.var.getDescShortHelpMsg();
            }
            Label shortHelpLabel = new Label((Composite)this, 0);
            layoutData = new GridData(1, 0x1000000, false, false, 3, 1);
            layoutData.horizontalIndent = 26;
            shortHelpLabel.setLayoutData((Object)layoutData);
            shortHelpLabel.setText(shortMsg);
            if (varType == VariableDescriptor.VariableType.File && this.var.getHasSampleResources()) {
                Link link = new Link((Composite)this, 0);
                link.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
                Object linkText = "Examples of accepted Input format : ";
                if (this.var.getSampleResources().size() == 1) {
                    linkText = "Example of accepted Input format : ";
                }
                for (String sample : this.var.getSampleResources()) {
                    String sampleDisplayName = this.var.getSampleResourcesName(sample);
                    linkText = (String)linkText + "<a href=\"" + sample + "\">" + sampleDisplayName + "</a>, ";
                }
                link.setText(((String)linkText).substring(0, ((String)linkText).length() - 2));
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String filename = e.text.substring(e.text.lastIndexOf(47) + 1);
                        JobVariableComposite.this.exportResources(JobVariableComposite.this.var.getJob().getJobDescID(), filename);
                    }
                });
            }
        }
    }
}

