/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class FileListVariableComposite
extends VariableComposite {
    List thisVarValueList1;
    List thisVarValueList2;
    boolean preIsPaired;
    protected static final int NORMAL_VAR_FILELIST_HORIZONTAL_INDENT = 25;
    boolean isLoopBack = false;

    public FileListVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable variable, int style) {
        super(parent, parentJobComposite, variable, style);
    }

    @Override
    protected void createContolsPart() {
        VariableDescriptor.VariableType varType;
        if (this.var.getDescGUIVisible() && (varType = this.var.getDescVarType()) == VariableDescriptor.VariableType.FileList) {
            this.createFileListVarComposite();
        }
    }

    private void createFileListVarComposite() {
        List varValueList;
        GridData layoutData;
        if (this.var.getDescAcceptedFileTypes() != null && this.var.getDescAcceptedFileTypes().size() > 1) {
            Composite topRow = new Composite((Composite)this, 0);
            layoutData = new GridData(1, 1, false, false, 3, 1);
            topRow.setLayoutData((Object)layoutData);
            topRow.setLayout((Layout)new GridLayout(2, false));
            Label comboVarlabel = new Label(topRow, 0x40 | this.style);
            comboVarlabel.setText("Input Format :");
            FontData fontdata = comboVarlabel.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            comboVarlabel.setFont(font);
            final Combo comboVar = new Combo(topRow, 0x80080C);
            comboVar.setItems(this.var.getDescAcceptedFileTypes().toArray(new String[this.var.getDescAcceptedFileTypes().size()]));
            String currentFileFormat = ((FileVariable)this.var).getFileFormat();
            int currentIndex = this.var.getDescAcceptedFileTypes().indexOf(currentFileFormat);
            comboVar.select(currentIndex);
            comboVar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedFileFormat = comboVar.getText();
                    if (selectedFileFormat.equals(((FileVariable)FileListVariableComposite.this.var).getFileFormat())) {
                        return;
                    }
                    FileListVariableComposite.this.var.setValue("");
                    ((FileVariable)FileListVariableComposite.this.var).setFileFormat(selectedFileFormat);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.varDesclabel = new Link((Composite)this, 0x40 | this.style);
        layoutData = new GridData(1, 0x1000000, false, false, 1, 1);
        layoutData.minimumWidth = 50;
        this.varDesclabel.setLayoutData((Object)layoutData);
        this.varDesclabel.setText(this.var.getDescFriendlyName() + " :");
        FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
        fontdata.setStyle(1);
        Font font = new Font((Device)this.getDisplay(), fontdata);
        this.varDesclabel.setFont(font);
        final Button checkButton = new Button((Composite)this, 0x20 | this.style);
        checkButton.setText(FileVariable.IS_PAIRED_TITLE);
        checkButton.setSelection(((FileVariable)this.var).getIsPairedFiles());
        this.preIsPaired = checkButton.getSelection();
        layoutData = new GridData(1, 1, true, false, 2, 1);
        checkButton.setLayoutData((Object)layoutData);
        this.thisVarValueList1 = varValueList = this.createFileList(this, false);
        this.varControl = varValueList;
        this.controlDecoration = new ControlDecoration((Control)varValueList, 0x1004000);
        this.controlDecoration.setDescriptionText("");
        this.controlDecoration.hide();
        varValueList.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (((FileListVariable)FileListVariableComposite.this.var).getIsPairedFiles()) {
                    return;
                }
                FileListVariableComposite.this.updateVar(varValueList);
            }
        });
        Listener handleValueChange = new Listener(){

            public void handleEvent(Event event) {
                if (((FileListVariable)FileListVariableComposite.this.var).getIsPairedFiles()) {
                    return;
                }
                FileListVariableComposite.this.updateList(varValueList);
            }
        };
        this.addListener(24, handleValueChange);
        checkButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ((FileVariable)FileListVariableComposite.this.var).setIsPairedFiles(checkButton.getSelection());
                VariableDescriptor.FileFormatInfo info = ((FileListVariable)FileListVariableComposite.this.var).getFileFormatInfo();
                FileListVariableComposite.this.var.setValue("");
                if (info.isPaired) {
                    FileListVariableComposite.this.varDesclabel.setText(info.title1 + " :");
                } else {
                    FileListVariableComposite.this.varDesclabel.setText(FileListVariableComposite.this.var.getDescFriendlyName() + " :");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        VariableDescriptor.FileFormatInfo info = ((FileListVariable)this.var).getFileFormatInfo();
        if (!info.showPairingOptions) {
            checkButton.setVisible(false);
        }
        this.buildFileLists(info);
        this.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 400) {
                    return;
                }
                VariableDescriptor.FileFormatInfo info = ((FileListVariable)FileListVariableComposite.this.var).getFileFormatInfo();
                if (!info.showPairingOptions) {
                    checkButton.setVisible(false);
                } else {
                    checkButton.setVisible(true);
                }
                if (FileListVariableComposite.this.preIsPaired != info.isPaired) {
                    FileListVariableComposite.this.thisC.setLayoutDeferred(true);
                    checkButton.setSelection(info.isPaired);
                    FileListVariableComposite.this.preIsPaired = info.isPaired;
                    FileListVariableComposite.this.buildFileLists(info);
                    FileListVariableComposite.this.var.getJob().notifyLayoutchanged();
                    FileListVariableComposite.this.thisC.layout(true);
                    FileListVariableComposite.this.thisC.setLayoutDeferred(false);
                }
            }
        });
    }

    protected List createFileList(Composite parent, boolean addToDisposables) {
        final List varValueList = new List(parent, 2818);
        if (addToDisposables) {
            this.disposableParts.add(varValueList);
        }
        int verticalSpan = 5;
        GridData layoutData = new GridData(4, 1, true, false, 1, verticalSpan);
        layoutData.horizontalIndent = 25;
        layoutData.minimumWidth = 500;
        layoutData.widthHint = 500;
        layoutData.heightHint = 150;
        varValueList.setLayoutData((Object)layoutData);
        String shortMsg = this.var.getDescShortHelpMsg();
        if (shortMsg == null || shortMsg.isEmpty()) {
            shortMsg = "Drag files from the FTP Browser";
        }
        varValueList.setToolTipText(shortMsg);
        Button moveUp = new Button((Composite)this, 8);
        layoutData = new GridData(1, 1, false, true, 1, 1);
        layoutData.widthHint = 40;
        layoutData.heightHint = 26;
        moveUp.setImage(SharedImages.ARROWUP);
        moveUp.setLayoutData((Object)layoutData);
        moveUp.setToolTipText("Move selected Items Up");
        moveUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (varValueList.getItemCount() == 0 || varValueList.getSelectionCount() == 0) {
                    return;
                }
                int[] selIndices = varValueList.getSelectionIndices();
                int startIndex = selIndices[0];
                if (startIndex == 0) {
                    return;
                }
                String[] selected = varValueList.getSelection();
                varValueList.remove(selIndices);
                int i = 0;
                while (i < selIndices.length) {
                    varValueList.add(selected[i], startIndex - 1 + i);
                    selIndices[i] = selIndices[i] - 1;
                    ++i;
                }
                varValueList.setSelection(selIndices);
                VariableDescriptor.FileFormatInfo info = ((FileListVariable)FileListVariableComposite.this.var).getFileFormatInfo();
                FileListVariableComposite.this.isLoopBack = true;
                if (info.isPaired) {
                    FileListVariableComposite.this.updateVar(FileListVariableComposite.this.thisVarValueList1, FileListVariableComposite.this.thisVarValueList2);
                } else {
                    FileListVariableComposite.this.updateVar(FileListVariableComposite.this.thisVarValueList1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (addToDisposables) {
            this.disposableParts.add(moveUp);
        }
        Label varDesclabel2 = new Label((Composite)this, 64);
        layoutData = new GridData(1, 1, false, false, 1, verticalSpan);
        varDesclabel2.setLayoutData((Object)layoutData);
        if (addToDisposables) {
            this.disposableParts.add(varDesclabel2);
        } else {
            String helpMsg = this.var.getDescHelpMsg();
            if (helpMsg == null) {
                helpMsg = "";
            }
            Object helpFiles = "\nAccepted Files Format :\n";
            for (String format : this.var.getDescAcceptedFileTypes()) {
                helpFiles = (String)helpFiles + format + ", ";
            }
            helpFiles = ((String)helpFiles).substring(0, ((String)helpFiles).length() - 2);
            varDesclabel2.setText(helpMsg + (String)helpFiles);
        }
        Button buttonSelectAll = new Button(parent, 8);
        if (addToDisposables) {
            this.disposableParts.add(buttonSelectAll);
        }
        buttonSelectAll.setText("Select all");
        layoutData = new GridData(1, 1, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonSelectAll.setLayoutData((Object)layoutData);
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                varValueList.selectAll();
            }
        });
        Button buttonSelectNone = new Button(parent, 8);
        if (addToDisposables) {
            this.disposableParts.add(buttonSelectNone);
        }
        buttonSelectNone.setText("Select None");
        layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonSelectNone.setLayoutData((Object)layoutData);
        buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                varValueList.deselectAll();
            }
        });
        Button buttonDeleteQuery = new Button(parent, 8);
        if (addToDisposables) {
            this.disposableParts.add(buttonDeleteQuery);
        }
        buttonDeleteQuery.setText("Delete Selected");
        layoutData = new GridData(1, 1024, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonDeleteQuery.setLayoutData((Object)layoutData);
        buttonDeleteQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (varValueList.getItemCount() == 0) {
                    return;
                }
                int[] selIndices = varValueList.getSelectionIndices();
                varValueList.remove(selIndices);
                if (selIndices[0] > 0) {
                    varValueList.setSelection(selIndices[0] - 1);
                } else {
                    varValueList.setSelection(0);
                }
                varValueList.notifyListeners(24, new Event());
            }
        });
        Button moveDown = new Button((Composite)this, 8);
        layoutData = new GridData(1, 1024, false, true, 1, 1);
        layoutData.widthHint = 40;
        layoutData.heightHint = 26;
        moveDown.setImage(SharedImages.ARROWDOWN);
        moveDown.setLayoutData((Object)layoutData);
        moveDown.setToolTipText("Move selected Items Down");
        moveDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (varValueList.getItemCount() == 0 || varValueList.getSelectionCount() == 0) {
                    return;
                }
                int[] selIndices = varValueList.getSelectionIndices();
                int startIndex = selIndices[0];
                if (startIndex + selIndices.length >= varValueList.getItemCount()) {
                    return;
                }
                String[] selected = varValueList.getSelection();
                varValueList.remove(selIndices);
                int i = 0;
                while (i < selIndices.length) {
                    varValueList.add(selected[i], startIndex + 1 + i);
                    selIndices[i] = selIndices[i] + 1;
                    ++i;
                }
                varValueList.setSelection(selIndices);
                VariableDescriptor.FileFormatInfo info = ((FileListVariable)FileListVariableComposite.this.var).getFileFormatInfo();
                FileListVariableComposite.this.isLoopBack = true;
                if (info.isPaired) {
                    FileListVariableComposite.this.updateVar(FileListVariableComposite.this.thisVarValueList1, FileListVariableComposite.this.thisVarValueList2);
                } else {
                    FileListVariableComposite.this.updateVar(FileListVariableComposite.this.thisVarValueList1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (addToDisposables) {
            this.disposableParts.add(moveDown);
        }
        int dropManagerType = -1;
        switch (this.var.getDescVarType()) {
            case Files: {
                dropManagerType = 3;
                break;
            }
            case FileList: {
                dropManagerType = 3;
                break;
            }
            case Folders: {
                dropManagerType = 4;
            }
        }
        if (dropManagerType != -1) {
            DropManager dropManager = DropManager.create((Control)varValueList, (int)2, (int)dropManagerType);
            varValueList.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                }
            });
        }
        return varValueList;
    }

    void buildFileLists(VariableDescriptor.FileFormatInfo info) {
        if (!this.disposableParts.isEmpty()) {
            for (Control part : this.disposableParts) {
                part.dispose();
            }
            this.disposableParts.clear();
        }
        this.thisVarValueList2 = null;
        if (info.isPaired) {
            List varValueList2;
            final List varValueList1 = (List)this.varControl;
            Label varDesclabel_ = new Label((Composite)this, 0x40 | this.style);
            GridData layoutData = new GridData(1, 0x1000000, false, false, 3, 1);
            layoutData.minimumWidth = 50;
            varDesclabel_.setLayoutData((Object)layoutData);
            this.varDesclabel.setText(info.title1 + " :");
            varDesclabel_.setText(info.title2 + " :");
            FontData fontdata = varDesclabel_.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            varDesclabel_.setFont(font);
            this.disposableParts.add(varDesclabel_);
            this.thisVarValueList2 = varValueList2 = this.createFileList(this, true);
            this.updateList(varValueList1, varValueList2);
            final Listener handleValueChange = new Listener(){

                public void handleEvent(Event event) {
                    FileListVariableComposite.this.updateVar(varValueList1, varValueList2);
                }
            };
            varValueList1.addListener(24, handleValueChange);
            varValueList2.addListener(24, handleValueChange);
            final Listener handleUpdateValueChange = new Listener(){

                public void handleEvent(Event event) {
                    FileListVariableComposite.this.updateList(varValueList1, varValueList2);
                }
            };
            this.addListener(24, handleUpdateValueChange);
            varValueList2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FileListVariableComposite.this.thisC.removeListener(24, handleUpdateValueChange);
                    if (!varValueList1.isDisposed()) {
                        varValueList1.removeListener(24, handleValueChange);
                    }
                }
            });
        } else {
            List varValueList = (List)this.varControl;
            this.varDesclabel.setText(this.var.getDescFriendlyName() + " :");
            this.updateList(varValueList);
        }
    }

    protected void updateVar(List varValueList1, List varValueList2) {
        String[] lines2;
        Object val = "";
        String[] lines1 = varValueList1.getItems();
        int largerSize = lines1.length > (lines2 = varValueList2.getItems()).length ? lines1.length : lines2.length;
        int i = 0;
        while (i < largerSize) {
            Object consValue = "";
            consValue = lines1.length > i ? lines1[i] : "";
            consValue = (String)consValue + ",";
            consValue = lines2.length > i ? (String)consValue + lines2[i] : (String)consValue;
            val = (String)val + (String)consValue + "\n";
            ++i;
        }
        this.var.setValue((String)val);
        System.out.println((String)val);
    }

    protected void updateVar(List varValueList) {
        Object val = "";
        String[] stringArray = varValueList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            val = (String)val + file + "\n";
            ++n2;
        }
        this.var.setValue((String)val);
        System.out.println((String)val);
    }

    protected void updateList(List varValueList) {
        if (this.isLoopBack) {
            this.isLoopBack = false;
            return;
        }
        String value = this.var.getValue();
        if (value != null) {
            String[] files;
            varValueList.removeAll();
            String[] stringArray = files = this.var.getValue().split("\n");
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!file.isEmpty()) {
                    varValueList.add(file);
                }
                ++n2;
            }
        }
    }

    protected void updateList(List varValueList1, List varValueList2) {
        if (this.isLoopBack) {
            this.isLoopBack = false;
            return;
        }
        String value = this.var.getValue();
        if (value != null) {
            String[] files;
            varValueList1.removeAll();
            varValueList2.removeAll();
            String[] stringArray = files = this.var.getValue().split("\n");
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    String[] pairedFiles = line.split(",");
                    if (pairedFiles.length == 2) {
                        if (!pairedFiles[0].isEmpty()) {
                            varValueList1.add(pairedFiles[0]);
                        }
                        if (!pairedFiles[1].isEmpty()) {
                            varValueList2.add(pairedFiles[1]);
                        }
                    } else if (line.startsWith(",")) {
                        varValueList2.add(pairedFiles[0]);
                    } else {
                        varValueList1.add(pairedFiles[0]);
                    }
                }
                ++n2;
            }
        }
    }
}

