/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.netools.jobs;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import java.util.HashMap;

public class VariablesHelper {
    public static final String R_SCRIPT_COMMON_OPTIONAL = "Optional";
    public static final String R_SCRIPT_COMMON_INPUT_OPTIONAL = "Input Files Arguments";
    public static final String R_SCRIPT_COMMON_OUTPUT_OPTIONAL = "Output Files Arguments";
    private static HashMap<String, CreateOptionCallBack> optionToAction = new HashMap();
    public static String R_SCRIPT_OPTION_OUT_IMAGE_WIDTH = "--img-width";
    public static String R_SCRIPT_OPTION_OUT_IMAGE_HEIGHT;
    public static String R_SCRIPT_OPTION_OUT_IMAGE_RESOLUTION;
    public static String R_SCRIPT_OPTION_OUT_FONT_POINTSIZE;
    public static String R_SCRIPT_OPTION_OUT_CSV_SEP;
    public static String R_SCRIPT_OPTION_IN_CSV_SEP;
    public static String R_SCRIPT_OPTION_IN_CSV_DEC;
    public static String R_SCRIPT_OPTION_IN_CSV_NO_HEADER;

    static {
        optionToAction.put(R_SCRIPT_OPTION_OUT_IMAGE_WIDTH, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionOutputImageWidth();
            }
        });
        R_SCRIPT_OPTION_OUT_IMAGE_HEIGHT = "--img-height";
        optionToAction.put(R_SCRIPT_OPTION_OUT_IMAGE_HEIGHT, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionOutputImageHeight();
            }
        });
        R_SCRIPT_OPTION_OUT_IMAGE_RESOLUTION = "--img-resolution";
        optionToAction.put(R_SCRIPT_OPTION_OUT_IMAGE_RESOLUTION, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionOutputImageResolution();
            }
        });
        R_SCRIPT_OPTION_OUT_FONT_POINTSIZE = "--font-pointsize";
        optionToAction.put(R_SCRIPT_OPTION_OUT_FONT_POINTSIZE, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionOutputFontPointSize();
            }
        });
        R_SCRIPT_OPTION_OUT_CSV_SEP = "--out-csvSep";
        optionToAction.put(R_SCRIPT_OPTION_OUT_CSV_SEP, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionOutputCSVSeparator();
            }
        });
        R_SCRIPT_OPTION_IN_CSV_SEP = "--in-csvSep";
        optionToAction.put(R_SCRIPT_OPTION_IN_CSV_SEP, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionInputCSVSeparator();
            }
        });
        R_SCRIPT_OPTION_IN_CSV_DEC = "--in-csvDec";
        optionToAction.put(R_SCRIPT_OPTION_IN_CSV_DEC, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionInputCSVDecPoint();
            }
        });
        R_SCRIPT_OPTION_IN_CSV_NO_HEADER = "--in-csv-no-header";
        optionToAction.put(R_SCRIPT_OPTION_IN_CSV_NO_HEADER, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return VariablesHelper.createOptionInputCSVHasNOHeader();
            }
        });
    }

    public static VariableDescriptor createInputCSVFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input CSV/TSV Files");
        varReadInputFile.setHelpMsg("Input CSV/TSV Files.");
        varReadInputFile.addAcceptedFileFormat("CSV");
        varReadInputFile.addAcceptedFileFormat("CSV");
        varReadInputFile.addAcceptedFileFormat("TXT");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputCSVFileVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input CSV/TSV File");
        varReadInputFile.setHelpMsg("Input CSV/TSV File.");
        varReadInputFile.addAcceptedFileFormat("CSV");
        varReadInputFile.addAcceptedFileFormat("CSV");
        varReadInputFile.addAcceptedFileFormat("TXT");
        return varReadInputFile;
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String key, String sharedVarGroup) {
        VariablesHelper.createSharedOptions(jobDesc, new String[]{key}, sharedVarGroup);
    }

    public static void createAllOptional(JobDescriptor jobDesc) {
        VariablesHelper.createSharedInputArgsOptions(jobDesc);
        VariablesHelper.createSharedOutputArsOptions(jobDesc);
    }

    public static void createSharedInputArgsOptions(JobDescriptor jobDesc) {
        String[] keys = new String[]{R_SCRIPT_OPTION_IN_CSV_SEP, R_SCRIPT_OPTION_IN_CSV_DEC, R_SCRIPT_OPTION_IN_CSV_NO_HEADER};
        VariablesHelper.createSharedOptions(jobDesc, keys, R_SCRIPT_COMMON_INPUT_OPTIONAL);
    }

    public static void createSharedOutputArsOptions(JobDescriptor jobDesc) {
        String[] keys = new String[]{R_SCRIPT_OPTION_OUT_CSV_SEP, R_SCRIPT_OPTION_OUT_IMAGE_WIDTH, R_SCRIPT_OPTION_OUT_IMAGE_HEIGHT, R_SCRIPT_OPTION_OUT_IMAGE_RESOLUTION, R_SCRIPT_OPTION_OUT_FONT_POINTSIZE};
        VariablesHelper.createSharedOptions(jobDesc, keys, R_SCRIPT_COMMON_OUTPUT_OPTIONAL);
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String[] keys, String sharedVarGroup) {
        VariableDescriptor optionalVar = null;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            optionalVar = null;
            if (optionToAction.containsKey(key)) {
                optionalVar = optionToAction.get(key).createOption();
                optionalVar.setVariableGroup(sharedVarGroup);
            }
            if (optionalVar != null) {
                jobDesc.addVariable(optionalVar);
            }
            ++n2;
        }
    }

    public static void addRules(WorkflowJob job) {
        for (String key : optionToAction.keySet()) {
            if (job.getVariableByCMDSwitch(key) == null) continue;
            optionToAction.get(key).addRules(job);
        }
    }

    public static VariableDescriptor createOptionOutputImageWidth() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Image width");
        optionalVar.setHelpMsg("Set the output image width.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_OUT_IMAGE_WIDTH);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        optionalVar.setDefaultValue("2500");
        return optionalVar;
    }

    public static VariableDescriptor createOptionOutputImageHeight() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Image height");
        optionalVar.setHelpMsg("Set the output image height.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_OUT_IMAGE_HEIGHT);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        optionalVar.setDefaultValue("2500");
        return optionalVar;
    }

    public static VariableDescriptor createOptionOutputImageResolution() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Image resolution");
        optionalVar.setHelpMsg("Set the output image resolution.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_OUT_IMAGE_RESOLUTION);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        optionalVar.setDefaultValue("300");
        return optionalVar;
    }

    public static VariableDescriptor createOptionOutputFontPointSize() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Imgae pointsize");
        optionalVar.setHelpMsg("Set the output image pointsize.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_OUT_FONT_POINTSIZE);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        optionalVar.setDefaultValue("8");
        return optionalVar;
    }

    public static VariableDescriptor createOptionOutputCSVSeparator() {
        SelectionListVariableDescriptor optionalVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Output CSV Separator");
        optionalVar.setHelpMsg("Set the the separator for the output CSV file.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_OUT_CSV_SEP);
        optionalVar.addOptionValue("Same", "same", "Same as input files");
        optionalVar.addOptionValue("Tab", "tab", "Tab Separator ");
        optionalVar.addOptionValue("Semicolon", "semicolon", "Semicolon (;) Separator");
        optionalVar.addOptionValue("Comma", "comma", "Comma (,) Separator");
        optionalVar.addOptionValue("Space", "space", "WhiteSpace Separator");
        optionalVar.setDefaultIndexValue(0);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionInputCSVSeparator() {
        SelectionListVariableDescriptor optionalVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Input CSV Separator");
        optionalVar.setHelpMsg("Set the the separator for the input CSV file.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_IN_CSV_SEP);
        optionalVar.addOptionValue("Tab", "tab", "Tab Separator ");
        optionalVar.addOptionValue("Semicolon", "semicolon", "Semicolon (;) Separator");
        optionalVar.addOptionValue("Comma", "comma", "Comma (,) Separator");
        optionalVar.addOptionValue("Space", "space", "WhiteSpace Separator");
        optionalVar.setDefaultIndexValue(1);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionInputCSVDecPoint() {
        SelectionListVariableDescriptor optionalVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Input CSV decimal separator");
        optionalVar.setHelpMsg("Set the the decimal separator for the input CSV file.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_IN_CSV_DEC);
        optionalVar.addOptionValue("Point", "point", "Point (.)");
        optionalVar.addOptionValue("Comma", "comma", "Comma (,)");
        optionalVar.setDefaultIndexValue(0);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionInputCSVHasNOHeader() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Input CSV without header");
        optionalVar.setHelpMsg("Specify if the input csv has header or not.");
        optionalVar.setCommandParamater(R_SCRIPT_OPTION_IN_CSV_NO_HEADER);
        optionalVar.setVariableGroup(R_SCRIPT_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static void addCompressFolderCmd(StringBuilder builder, String arcName, String folder) {
        builder.append(BashHelper.st((String)Tracking.trackLog((String)"Compressing Result")));
        builder.append(BashHelper.st((String)("tar -czvf " + folder + "/" + arcName + ".tar.gz   -C " + folder + " *")));
    }

    static interface CreateOptionCallBack {
        public VariableDescriptor createOption();

        public void addRules(WorkflowJob var1);
    }

    static abstract class NoRulesCreateOptionCallBack
    implements CreateOptionCallBack {
        NoRulesCreateOptionCallBack() {
        }

        @Override
        public void addRules(WorkflowJob job) {
        }
    }
}

