/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.netools.jobs;

import com.biotechvana.netools.jobs.NetoolsJob;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.descriptors.FilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashBlock;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.executer.BashStatement;
import com.biotechvana.workflow.executer.CMLTemplate;
import com.biotechvana.workflow.executer.IFObject;
import com.biotechvana.workflow.executer.cmds.CP;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.List;

public class NetworkJob
extends NetoolsJob {
    public static final String JOB_ID = "network_build";
    public static final String JOB_NAME = "network_build";
    public static final String INPUT_NETWORK_NAME = "INPUT_NETWORK_NAME";
    public static final String INPUT_NETWORK_DIR = "INPUT_NETWORK_DIR";
    public static final String OPTION_NETWORK_METHOD = "OPTION_NETWORK_METHOD";
    public static final String OPTION_NETWORK_SCORE = "OPTION_NETWORK_SCORE";
    public static final String OPTION_BOOTSTRAP_SCORE_THRESHOLD = "OPTION_BOOTSTRAP_SCORE_THRESHOLD";
    public static final String OPTION_ADAPTIVE_SELECTION = "OPTION_ADAPTIVE_SELECTION";
    public static final String OPTION_BIC_THRESHOLD = "OPTION_BIC_THRESHOLD";
    public static final String OPTION_PVALUE_THRESHOLD = "OPTION_PVALUE_THRESHOLD";
    public static final String OPTION_RUN_NETWORK_SELECTION = "OPTION_RUN_NETWORK_SELECTION";
    public static final String OPTION_BOOTSTRAP = "OPTION_BOOTSTRAP";
    public static final String OPTION_N_BOOTSTRAP = "OPTION_N_BOOTSTRAP";
    public static final String OPTION_WL_FILENAME = "OPTION_WL_FILENAME";
    public static final String OPTION_BL_FILENAME = "OPTION_BL_FILENAME";
    public static final String OUTPUT_NETWORK_EDGES = "OUTPUT_NETWORK_EDGES";
    private static final String INPUT_VARIABLES_FILES = "INPUT_VARIABLES_FILES";
    private static final String INPUT_DATA_FILES = "INPUT_FILES";

    public NetworkJob() {
        super("network_build", "network_build");
    }

    public void setNetworkName(String networkName) {
        this.setValue(INPUT_NETWORK_NAME, networkName);
    }

    public void setNetworkMethod(String networkMethod) {
        this.setValue(OPTION_NETWORK_METHOD, networkMethod);
    }

    public void setNetworkScore(String networkScore) {
        this.setValue(OPTION_NETWORK_SCORE, networkScore);
    }

    public void setBootstrapScoreThreshold(double scoreThreshold) {
        this.setValue(OPTION_BOOTSTRAP_SCORE_THRESHOLD, Double.toString(scoreThreshold));
    }

    public void setBootstrap(boolean bootstrap) {
        this.setValue(OPTION_BOOTSTRAP, bootstrap);
    }

    public void setNBootstrap(int nBootstrap) {
        this.setValue(OPTION_N_BOOTSTRAP, Integer.toString(nBootstrap));
    }

    public void setWLFilename(String wlFilename) {
        this.setValue(OPTION_WL_FILENAME, wlFilename);
    }

    public void setBLFilename(String blFilename) {
        this.setValue(OPTION_BL_FILENAME, blFilename);
    }

    @Override
    protected void createInputs() {
        super.createInputs();
        VariableDescriptor varInputNetwork = VariableDescriptor.createDescriptorFor((String)INPUT_NETWORK_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputNetwork.isRequired = true;
        varInputNetwork.setVariableName("Network Name");
        varInputNetwork.setHelpMsg("Network Name.");
        this.jobDesc.addVariable(varInputNetwork);
        FilesVariableDescriptor varInputFiles = VariableDescriptor.Files((String)INPUT_DATA_FILES, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputFiles.isRequired = true;
        varInputFiles.setVariableName("Input Data Files");
        varInputFiles.setHelpMsg("Input Data Files.");
        varInputFiles.setCommandParamater("-i");
        varInputFiles.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)varInputFiles);
        FilesVariableDescriptor varInputVariablesFiles = VariableDescriptor.Files((String)INPUT_VARIABLES_FILES, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputVariablesFiles.isRequired = true;
        varInputVariablesFiles.setVariableName("Input Variables Files");
        varInputVariablesFiles.setHelpMsg("Input Variables Files.");
        varInputVariablesFiles.setCommandParamater("-v");
        varInputVariablesFiles.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)varInputVariablesFiles);
        VariableDescriptor varInputNetworkDir = VariableDescriptor.createDescriptorFor((String)INPUT_NETWORK_DIR, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputNetworkDir.isRequired = true;
        varInputNetworkDir.setVariableName("Network Directory");
        varInputNetworkDir.setHelpMsg("Network Directory.");
        this.jobDesc.addVariable(varInputNetworkDir);
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        VariableDescriptor networkMethod = VariableDescriptor.createDescriptorFor((String)OPTION_NETWORK_METHOD, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        networkMethod.setVariableName("Network Method");
        networkMethod.setHelpMsg("Network Method.");
        this.jobDesc.addVariable(networkMethod);
        VariableDescriptor networkScore = VariableDescriptor.createDescriptorFor((String)OPTION_NETWORK_SCORE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        networkScore.setVariableName("Network Score");
        networkScore.setHelpMsg("Network Score.");
        networkScore.setCommandParamater("--score");
        this.jobDesc.addVariable(networkScore);
        VariableDescriptor bootstrap = VariableDescriptor.createDescriptorFor((String)OPTION_BOOTSTRAP, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        bootstrap.setVariableName("Bootstrap");
        bootstrap.setHelpMsg("Bootstrap.");
        this.jobDesc.addVariable(bootstrap);
        VariableDescriptor nBootstrap = VariableDescriptor.createDescriptorFor((String)OPTION_N_BOOTSTRAP, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        nBootstrap.setVariableName("N Bootstrap");
        nBootstrap.setHelpMsg("N Bootstrap.");
        nBootstrap.setCommandParamater("-n");
        nBootstrap.setCommandParamaterAlt("--num-bootstrap");
        this.jobDesc.addVariable(nBootstrap);
        VariableDescriptor runNetworkSelection = VariableDescriptor.createDescriptorFor((String)OPTION_RUN_NETWORK_SELECTION, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        runNetworkSelection.setVariableName("Run Network Selection");
        runNetworkSelection.setHelpMsg("Run Network Selection.");
        runNetworkSelection.setCommandParamater("--network-selection");
        this.jobDesc.addVariable(runNetworkSelection);
        VariableDescriptor adaptiveSelection = VariableDescriptor.createDescriptorFor((String)OPTION_ADAPTIVE_SELECTION, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        adaptiveSelection.setVariableName("Adaptive Selection");
        adaptiveSelection.setHelpMsg("Adaptive Selection.");
        adaptiveSelection.setCommandParamater("--adaptive-selection");
        this.jobDesc.addVariable(adaptiveSelection);
        VariableDescriptor scoreThreshold = VariableDescriptor.createDescriptorFor((String)OPTION_BOOTSTRAP_SCORE_THRESHOLD, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        scoreThreshold.setVariableName("Score Threshold");
        scoreThreshold.setHelpMsg("Score Threshold.");
        scoreThreshold.setCommandParamater("--bootstrap-cutoff");
        this.jobDesc.addVariable(scoreThreshold);
        VariableDescriptor bicThreshold = VariableDescriptor.createDescriptorFor((String)OPTION_BIC_THRESHOLD, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        bicThreshold.setVariableName("BIC Threshold");
        bicThreshold.setHelpMsg("BIC Threshold.");
        bicThreshold.setCommandParamater("--bic-threshold");
        this.jobDesc.addVariable(bicThreshold);
        VariableDescriptor pvalueThreshold = VariableDescriptor.createDescriptorFor((String)OPTION_PVALUE_THRESHOLD, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        pvalueThreshold.setVariableName("PValue Threshold");
        pvalueThreshold.setHelpMsg("PValue Threshold.");
        pvalueThreshold.setCommandParamater("--pvalue-threshold");
        this.jobDesc.addVariable(pvalueThreshold);
        VariableDescriptor wlFilename = VariableDescriptor.createDescriptorFor((String)OPTION_WL_FILENAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        wlFilename.setVariableName("WL Filename");
        wlFilename.setHelpMsg("WL Filename.");
        wlFilename.setCommandParamater("-w");
        this.jobDesc.addVariable(wlFilename);
        VariableDescriptor blFilename = VariableDescriptor.createDescriptorFor((String)OPTION_BL_FILENAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        blFilename.setVariableName("BL Filename");
        blFilename.setHelpMsg("BL Filename.");
        blFilename.setCommandParamater("-b");
        this.jobDesc.addVariable(blFilename);
    }

    @Override
    protected void createOutputs() {
        super.createOutputs();
        VariableDescriptor varOutputNetworkEdges = VariableDescriptor.createDescriptorFor((String)OUTPUT_NETWORK_EDGES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputNetworkEdges.isRequired = true;
        varOutputNetworkEdges.setVariableName("Network Edges");
        varOutputNetworkEdges.setHelpMsg("Network Edges.");
        this.jobDesc.addVariable(varOutputNetworkEdges);
    }

    @Override
    protected void createRules() {
        super.createRules();
    }

    protected void generateCommand(StringBuilder builder) {
        super.generateCommand(builder);
        builder.append(NetworkJob.st((String)BashHelper.assign((String)"out_prefix", (JobVariable)this.getVariable(INPUT_NETWORK_NAME))));
        CMLTemplate bootstrapTemplate = new CMLTemplate();
        bootstrapTemplate.setBaseCommand("/home/gpro/gpro_bin/netools/bnlean_bootstrap.R");
        bootstrapTemplate.setTrackInput(this.getVariable(INPUT_NETWORK_NAME));
        bootstrapTemplate.addArgs("-s SampleID");
        bootstrapTemplate.addArgs(this.getOptionParamatersStrAs$());
        bootstrapTemplate.addArgs("--output-prefix ${outputFolder}/${out_prefix}");
        FileVariable outputEdgesFile = (FileVariable)this.getVariable(OUTPUT_NETWORK_EDGES);
        IFObject mainBlock = BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(OPTION_BOOTSTRAP)));
        BashBlock thenBlock = mainBlock.getThenBlock();
        thenBlock.addStatment((BashStatement)bootstrapTemplate);
        thenBlock.addStatment(NetworkJob.st((String)BashHelper.assign((JobVariable)outputEdgesFile, (String)"${outputFolder}/${out_prefix}.bootstrap.edges.csv")));
        BashBlock elseBlock = mainBlock.getElseBlock();
        elseBlock.addStatment((BashStatement)bootstrapTemplate);
        elseBlock.addStatment(NetworkJob.st((String)BashHelper.assign((JobVariable)outputEdgesFile, (String)"${outputFolder}/${out_prefix}.edges.csv")));
        mainBlock.generate(builder);
        IFObject selectionBlock = BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(OPTION_RUN_NETWORK_SELECTION)));
        BashBlock selectionThenBlock = selectionBlock.getThenBlock();
        BashBlock selectionElseBlock = selectionBlock.getElseBlock();
        selectionThenBlock.addStatment(NetworkJob.st((String)BashHelper.assign((JobVariable)outputEdgesFile, (String)"${outputFolder}/${out_prefix}.edges.csv")));
        selectionThenBlock.addStatment((BashStatement)new CP().setWithWarning(true).setSource(outputEdgesFile.$()).setDestination(this.getVariable(INPUT_NETWORK_DIR).$()));
        selectionThenBlock.addStatment((BashStatement)new CP().setWithWarning(true).setSource("${outputFolder}/${out_prefix}.nodes.csv").setDestination(this.getVariable(INPUT_NETWORK_DIR).$()));
        selectionThenBlock.addStatment("cp -r ${outputFolder}/models " + this.getVariable(INPUT_NETWORK_DIR).$());
        selectionElseBlock.addStatment((BashStatement)new CP().setWithWarning(true).setSource(outputEdgesFile.$()).setDestination(this.getVariable(INPUT_NETWORK_DIR).$()));
        selectionElseBlock.addStatment((BashStatement)new CP().setWithWarning(true).setSource("${outputFolder}/${out_prefix}.nodes.csv").setDestination(this.getVariable(INPUT_NETWORK_DIR).$()));
        selectionBlock.generate(builder);
    }

    public void setInputFiles(List<String> datasetsDataFiles) {
        ((FilesVariable)this.getVariable(INPUT_DATA_FILES)).setValue(datasetsDataFiles);
    }

    public void setInputVariablesFiles(List<String> datasetsVariablesFiles) {
        ((FilesVariable)this.getVariable(INPUT_VARIABLES_FILES)).setValue(datasetsVariablesFiles);
    }

    public void setRunModelSelection(boolean runModelSelection) {
        this.setValue(OPTION_RUN_NETWORK_SELECTION, runModelSelection);
    }

    public void setBICScoreThreshold(Double bicScoreThreshold) {
        this.setValue(OPTION_BIC_THRESHOLD, Double.toString(bicScoreThreshold));
    }

    public void setPValueThreshold(Double pvalueThreshold) {
        this.setValue(OPTION_PVALUE_THRESHOLD, Double.toString(pvalueThreshold));
    }

    public void setAdaptiveBootstrapScoreSelection(boolean adaptiveBootstrapScoreSelection) {
        this.setValue(OPTION_ADAPTIVE_SELECTION, adaptiveBootstrapScoreSelection);
    }

    public void setNetworkDirectory(String networkBaseDirectory) {
        this.setValue(INPUT_NETWORK_DIR, networkBaseDirectory);
    }
}

