/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.netools.jobs;

import com.biotechvana.netools.jobs.DatasetJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.executer.BashStatement;
import com.biotechvana.workflow.executer.CMLTemplate;
import com.biotechvana.workflow.executer.cmds.CP;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class DTUploadJob
extends DatasetJob {
    public static final String JOB_ID = "dt_upload";
    public static final String JOB_NAME = "DTUpload";
    public static final String OPTION_CSV_SEPARATOR = "OPTION_CSV_SEPARATOR";
    public static final String OPTION_SAMPLE_NAME_COLUMN = "OPTION_SAMPLE_NAME_COLUMN";
    public static final String OUTPUT_VARIABLES_CSV_FILE = "OUTPUT_VARIABLES_CSV_FILE";
    public static final String OUTPUT_DATA_CSV_FILE = "OUTPUT_FILES";
    public static final String OUTPUT_SAMPLES_CSV_FILE = "OUTPUT_SAMPLES_CSV_FILE";
    public static final String OPTION_DATASET_TYPE = "OPTION_DATASET_TYPE";

    public DTUploadJob() {
        super(JOB_ID, JOB_NAME);
    }

    public void setCSVSeparator(String csvSeparator) {
        this.setValue(OPTION_CSV_SEPARATOR, csvSeparator);
    }

    public void setSampleNameColumn(String sampleNameColumn) {
        this.setValue(OPTION_SAMPLE_NAME_COLUMN, sampleNameColumn);
    }

    public void setDatasetType(String datasetType) {
        this.setValue(OPTION_DATASET_TYPE, datasetType);
    }

    @Override
    protected void createInputs() {
        super.createInputs();
        VariableDescriptor varInputCsv = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputCsv.isRequired = true;
        varInputCsv.setVariableName("Input CSV File");
        varInputCsv.setHelpMsg("Input CSV File.");
        this.jobDesc.addVariable(varInputCsv);
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        SelectionListVariableDescriptor csvSeparatorOption = VariableDescriptor.SelectionList((String)OPTION_CSV_SEPARATOR, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        csvSeparatorOption.addOptionValue("comma");
        csvSeparatorOption.addOptionValue("semicolon");
        csvSeparatorOption.addOptionValue("tab");
        csvSeparatorOption.addOptionValue("space");
        csvSeparatorOption.setVariableName("Csv Separator");
        csvSeparatorOption.setCommandParamater("--sep");
        this.jobDesc.addVariable((VariableDescriptor)csvSeparatorOption);
        VariableDescriptor sampleNameColumn = VariableDescriptor.createDescriptorFor((String)OPTION_SAMPLE_NAME_COLUMN, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        sampleNameColumn.setVariableName("Sample Name Column");
        sampleNameColumn.setHelpMsg("The column that contains the sample names.");
        sampleNameColumn.setCommandParamater("--sample_column");
        this.jobDesc.addVariable(sampleNameColumn);
        VariableDescriptor datasetTypeColumn = VariableDescriptor.createDescriptorFor((String)OPTION_DATASET_TYPE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        datasetTypeColumn.setVariableName("Dataset Type");
        datasetTypeColumn.setHelpMsg("The type of the dataset, General, Mixed, Experiment, qPCR, Covariates, Outcome, Microbiota, RNAseq.");
        datasetTypeColumn.setCommandParamater("--data_type");
        this.jobDesc.addVariable(datasetTypeColumn);
    }

    @Override
    protected void createOutputs() {
        super.createOutputs();
        VariableDescriptor outputDataCSVFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_DATA_CSV_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputDataCSVFile.isRequired = true;
        outputDataCSVFile.setVariableName("Output CSV File");
        outputDataCSVFile.setHelpMsg("Output CSV File.");
        this.jobDesc.addVariable(outputDataCSVFile);
        VariableDescriptor outputVariablesCSVFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIABLES_CSV_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVariablesCSVFile.isRequired = true;
        outputVariablesCSVFile.setVariableName("Output Variables CSV File");
        outputVariablesCSVFile.setHelpMsg("Output Variables CSV File.");
        this.jobDesc.addVariable(outputVariablesCSVFile);
        VariableDescriptor outputSamplesCSVFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_SAMPLES_CSV_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputSamplesCSVFile.isRequired = true;
        outputSamplesCSVFile.setVariableName("Output Samples CSV File");
        outputSamplesCSVFile.setHelpMsg("Output Samples CSV File.");
        this.jobDesc.addVariable(outputSamplesCSVFile);
    }

    protected void generateCommand(StringBuilder builder) {
        super.generateCommand(builder);
        FileVariable inputFiles = (FileVariable)this.getVariable("INPUT_FILES");
        FileVariable outputDataCSVFile = (FileVariable)this.getVariable(OUTPUT_DATA_CSV_FILE);
        FileVariable outputVariablesCSVFile = (FileVariable)this.getVariable(OUTPUT_VARIABLES_CSV_FILE);
        FileVariable outputSamplesCSVFile = (FileVariable)this.getVariable(OUTPUT_SAMPLES_CSV_FILE);
        this.getVariable("INPUT_DATASET_DIRECTORY");
        builder.append(DTUploadJob.st((String)BashHelper.assign((String)"df_basename", (JobVariable)this.getVariable("DATASET_ID"))) + DTUploadJob.st((String)BashHelper.assign((String)"out_prefix", (String)"01_${df_basename}")) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputDataCSVFile, (String)"${outputFolder}/${out_prefix}.csv")) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputVariablesCSVFile, (String)"${outputFolder}/${out_prefix}_variables.csv")) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputSamplesCSVFile, (String)"${outputFolder}/${out_prefix}_samples.csv")));
        CMLTemplate template = new CMLTemplate();
        template.setBaseCommand("/home/gpro/gpro_bin/netools/preprocess_ds.R");
        template.addArgs(this.getOptionParamatersStrAs$());
        template.addArgs("--out_prefix ${outputFolder}/${out_prefix}");
        template.addArgs((JobVariable)inputFiles);
        template.getAfter().addStatment((BashStatement)new CP().setWithWarning(true).setSource(outputVariablesCSVFile.$()).setDestination(this.getVariable("INPUT_DATASET_DIRECTORY").$()));
        template.getAfter().addStatment((BashStatement)new CP().setWithWarning(true).setSource(outputSamplesCSVFile.$()).setDestination(this.getVariable("INPUT_DATASET_DIRECTORY").$()));
        template.getAfter().addStatment((BashStatement)new CP().setWithWarning(true).setSource(outputDataCSVFile.$()).setDestination(this.getVariable("INPUT_DATASET_DIRECTORY").$()));
        template.generate(builder);
        builder.append(DTUploadJob.st((String)BashHelper.assign((String)"dataset_dir", (JobVariable)this.getVariable("INPUT_DATASET_DIRECTORY"))) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputDataCSVFile, (String)"${dataset_dir}/${out_prefix}.csv")) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputVariablesCSVFile, (String)"${dataset_dir}/${out_prefix}_variables.csv")) + DTUploadJob.st((String)BashHelper.assign((JobVariable)outputSamplesCSVFile, (String)"${dataset_dir}/${out_prefix}_samples.csv")));
    }
}

