/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxTrimmerJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Trimmer";
    private static final String HELP = "FASTX Trimmer: Trim sequences from FASTA/FASTQ files";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_trimmer_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_trimmer_usage</a>";
    public static final String JOB_ID = "FASTX_Trimmer";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Trimmer";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastxTrimmerJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Trimmer";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("First base to keep");
        varOption.setCommandParamater("-f");
        varOption.setHelpMsg("First base to keep. Default is 1 (=first base)");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Last base to keep.");
        varOption.setCommandParamater("-l");
        varOption.setHelpMsg("Last base to keep. Default is entire read");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim N nucleotides from the end of the read.");
        varOption.setCommandParamater("-t");
        varOption.setHelpMsg("Trim N nucleotides from the end of the read. '-t'  can not be used with '-l' and '-f'.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Discard reads shorter than");
        varOption.setCommandParamater("-m");
        varOption.setHelpMsg("With [-t], discard reads shorter than MINLEN.");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTX_TRIMMER_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.$inptFileExt " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

