/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxRenamerJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Renamer";
    private static final String HELP = "FASTX Renamer: Rename sequences from FASTA/FASTQ files";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_renamer_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_renamer_usage</a>";
    public static final String JOB_ID = "FASTX_Renamer";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Renamer";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastxRenamerJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Renamer";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        SelectionListVariableDescriptor varOption = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Rename type: SEQ - use the nucleotides sequence as the name. COUNT - use simply counter as the name");
        varOption.setCommandParamater("-n");
        varOption.setHelpMsg("Rename type: SEQ - use the nucleotides sequence as the name. COUNT - use simply counter as the name.");
        varOption.addOptionValue("SEQ");
        varOption.addOptionValue("COUNT");
        this.jobDesc.addVariable((VariableDescriptor)varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTX_RENAMER_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.$inptFileExt " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

