/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxClipperJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Clipper";
    private static final String HELP = "FASTX Clipper: Clip adapter from FASTA/FASTQ files";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_clipper_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_clipper_usage</a>";
    public static final String JOB_ID = "FASTX_Clipper";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Clipper";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastxClipperJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Clipper";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Rename sequence identifiers to numbers");
        varOption.setCommandParamater("-r");
        varOption.setHelpMsg("Rename sequence identifiers to numbers");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("ADAPTER string.");
        varOption.setCommandParamater("-a");
        varOption.setHelpMsg("ADAPTER string. default is CCTTAAGG (dummy adapter).");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Discard sequences shorter than N nucleotides.");
        varOption.setCommandParamater("-l");
        varOption.setHelpMsg("discard sequences shorter than N nucleotides. default is 5.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Keep the adapter and N bases after it");
        varOption.setCommandParamater("-d");
        varOption.setHelpMsg("Keep the adapter and N bases after it.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Discard non-clipped sequences.");
        varOption.setCommandParamater("-c");
        varOption.setHelpMsg("Discard non-clipped sequences.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Discard clipped sequences.");
        varOption.setCommandParamater("-C");
        varOption.setHelpMsg("Discard clipped sequences.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Report Adapter-Only sequences.");
        varOption.setCommandParamater("-k");
        varOption.setHelpMsg("Report Adapter-Only sequences.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Keep sequences with unknown (N) nucleotides.");
        varOption.setCommandParamater("-n");
        varOption.setHelpMsg("Keep sequences with unknown (N) nucleotides. default is to discard such sequences.");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTX_CLIPPER_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.$inptFileExt " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

