/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;

public class PreProcessingCorrectTrimPacbioReadsJob
extends WorkflowJob {
    public static final String JOB_ID = "correct_trim_pacbio";
    public static final String JOB_NAME = "Correct and Trim Pacbio";
    private static final String INPUT_FASTQ_FILE = "INPUT_FILES";

    public PreProcessingCorrectTrimPacbioReadsJob() {
        this.jobName = JOB_NAME;
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc("Correct and Trim Pacbio Reads");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ Files");
        varFastaQ.addAcceptedFileFormat("FASTQ", false, true);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.isRequired = true;
        varOption.setVariableName("Genome Size");
        varOption.setHelpMsg("Genome Size in the format <number>[g|m|k] ");
        varOption.setCommandParamater("-genomeSize");
        varOption.setCommandParamaterSep("=");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varOutputFiles);
        this.initJobFromDesc(this.jobDesc);
    }

    protected void generateCommand(StringBuilder command) {
        String progName = "canu";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inputBaseName=$(basename $_File | cut -d. -f1);\n" + progName + " -correct " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-raw $_File \n";
        forBody = String.valueOf(forBody) + progName + " -trim " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-corrected  correction/$inputBaseName.correctedReads.fastq \n";
        forBody = String.valueOf(forBody) + progName + " -assemble " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-corrected trimming/$inputBaseName.trimmedReads.fastq \n ";
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTQ_FILE).$("@"), (String)forBody));
        forBody = "inputFileBaseName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + " );\n";
        forBody = String.valueOf(forBody) + this.getVariable("OUTPUT_FILES").getBashVarName("0,$_i") + "=" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${inputFileBaseName} ";
        forBody = String.valueOf(forBody) + BashHelper.IF((String)("-n \"" + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "\""), (String)("inputFileBaseName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + " );\n" + this.getVariable("OUTPUT_FILES").getBashVarName("1,$_i") + "=" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/$inputFileBaseName "));
        command.append(BashHelper.forIndex((String)"_i", (String)((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getCountAsBashVarName(), (String)"_i++", (String)forBody));
        command.append("cd $HOME \n");
    }

    public String getJobCommand() {
        String progName = "canu";
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        String outputFolder = this.getJobDescID();
        this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
        this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        StringBuilder command = new StringBuilder();
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTQ_FILE).getBashVarDecleration());
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inputBaseName=$(basename $_File | cut -d. -f1);\n" + progName + " -correct " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-raw $_File \n";
        forBody = String.valueOf(forBody) + progName + " -trim " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-corrected  correction/$inputBaseName.correctedReads.fastq \n";
        forBody = String.valueOf(forBody) + progName + " -assemble " + this.getOptionParamaters() + " -d " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " -p $inputBaseName  -pacbio-corrected trimming/$inputBaseName.trimmedReads.fastq \n ";
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTQ_FILE).$("@"), (String)forBody));
        command.append("cd $HOME \n");
        command.append("\n");
        return command.toString();
    }
}

