/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.IListVariableDescriptor;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class MappingSTARJob
extends ISWFJob {
    public static final String JOB_ID = "STAR";
    public static final String JOB_NAME = "STAR";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String OUTPUT_BAM_FILES = "OUTPUT_FILES";
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String OUTPUT_LIBRARY_NAMES = "OUTPUT_LIBRARY_NAMES";
    public static final String OPTION_RM_FILTER = "OPTION_RM";
    public static final String OPTION_BAM_OUT = "BAM_OUT";
    public static final String OPTION_BAM_Unsorted = "Unsorted";
    public static final String OPTION_BAM_Sorted = "SortedByCoordinate";

    public MappingSTARJob() {
        super("STAR", "STAR");
        this.jobDesc.setDesc("STAR: ultrafast universal RNA-seq aligner");
        this.jobDesc.addPublication(new Publication().setAuthors("Dobin, Alexander, et al.").setTitle("STAR: ultrafast universal RNA-seq aligner").setJournal("Bioinformatics").setVolume(29).setIssue(1).setYear(2013).setPages("15-21").setDOI("10.1093/bioinformatics/bts635").setPubmed("23104886"));
        this.jobDesc.addLink(new JobLink().setTitle("STAR").setUrl("https://github.com/alexdobin/STAR/blob/master/doc/STARmanual.pdf").setType(JobLink.LinkType.Manual));
    }

    protected void createInputs() {
        this.createIndexSection();
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input File");
        varReadInputFile.addAcceptedFileFormat("FASTQ", true, true);
        varReadInputFile.setHelpMsg("Input Fastq files to map.");
        varReadInputFile.setIsTracked(true);
        varReadInputFile.setCommandParamater("--readFilesIn");
        varReadInputFile.setSubProgName("_NO_CMD_");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)OUTPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.setGUIVisible(false);
        this.jobDesc.addVariable(outputVarLibraryName);
        VariableDescriptor outputVarAcceptedHits = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVarAcceptedHits.isRequired = true;
        outputVarAcceptedHits.setVariableName("accepted_hits.bam");
        outputVarAcceptedHits.setHelpMsg("A list of read alignments in BAM format.");
        this.jobDesc.addVariable(outputVarAcceptedHits);
        PreprocessingFilters.addPrepresoccesingRMFilter(this.jobDesc, outputVarAcceptedHits, this.jobDesc.getVariableDescById(OPTION_RM_FILTER));
    }

    protected void createOptions() {
        String OUTPUT_FILE_OPTION = "Output Files";
        VariableDescriptor varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_RM_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Overall alignment rate");
        varOptions.setHelpMsg("Min overall alignment rate to consider the mapping succesfull. Has no effect of the bahavoiur of The mapper. Only used for pipeline managment and tracking. Default 80");
        varOptions.setDefaultValue("80");
        varOptions.setVariableGroup(OUTPUT_FILE_OPTION);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Output Unmapped Reads");
        varOptions.setHelpMsg("Output of unmapped and partially mapped (i.e. mapped only one mate of a paired end read) reads in separate file(s).");
        varOptions.setVariableGroup(OUTPUT_FILE_OPTION);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_OUT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Output Alignment files in Bam Format");
        varOptions.setHelpMsg("Output Alignment files in Bam Format");
        varOptions.setDefaultValue("true");
        varOptions.setVariableGroup(OUTPUT_FILE_OPTION);
        varOptions.setSubProgName("_NO_CMD_");
        varOptions.setCommandParamater("--outSAMtype BAM");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_Sorted, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Output Sorted By Coordinate Alignment Bam Files");
        varOptions.setHelpMsg("Output Alignment files in Bam Format");
        varOptions.setVariableGroup(OUTPUT_FILE_OPTION);
        varOptions.setSubProgName("_NO_CMD_");
        varOptions.setDefaultValue("true");
        varOptions.setCommandParamater("--outSAMtype BAM SortedByCoordinate");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_Unsorted, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Output unsorted Alignment files Bam Files ");
        varOptions.setHelpMsg("Output Alignment files in Bam Format");
        varOptions.setVariableGroup(OUTPUT_FILE_OPTION);
        varOptions.setSubProgName("_NO_CMD_");
        varOptions.setCommandParamater("--outSAMtype BAM Unsorted");
        this.jobDesc.addVariable(varOptions);
        String ANNOTATIONS_OPTION = "Splice Junctions";
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Annotations GTF file");
        varOptions.setHelpMsg("GTF file with annotations to use in the mapping step");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbGTFfile");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Genomic coordinates file");
        varOptions.setHelpMsg("Files with genomic coordinates (chr <tab> start <tab> end <tab> strand) for the splice junction introns.");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbFileChrStartEnd");
        ((IListVariableDescriptor)varOptions).setCmdListMergerSep(" ");
        ((IListVariableDescriptor)varOptions).setCmdListMergeStrategy(CmdListMergeStrategy.Once);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Chromosome names prefix");
        varOptions.setHelpMsg("prefix for chromosome names in a GTF file (e.g. \u2019chr\u2019 for using ENSMEBL annotations with UCSC genomes)");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbGTFchrPrefix");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("GTF feature as Exon");
        varOptions.setHelpMsg("Feature type in GTF file to be used as exons for building transcripts. Default exon");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbGTFfeatureExon");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Exon Parent Transcript GTF tag");
        varOptions.setHelpMsg("Tag name to be used as exons\u2019 transcript-parents. Default transcript_id");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbGTFtagExonParentTranscript");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Exon Parent Gene GTF tag");
        varOptions.setHelpMsg("Tag name to be used as exons\u2019 gene-parents. Default gene_id");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbGTFtagExonParentGene");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Overhang");
        varOptions.setHelpMsg("Length of the donor/acceptor sequence on each side of the junctions, ideally = (mate length - 1). Default 100");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbOverhang");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Extra alignment score");
        varOptions.setHelpMsg("Extra alignment score for alignmets that cross database junctions. Default 2");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbScore");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.isRequired = true;
        varOptions.setVariableName("Save all files when splice junctions are inserted on the fly at the mapping step");
        varOptions.setHelpMsg("Indicate which files to save when sjdb junctions are inserted on the fly at the mapping step by  default only small junction / transcript files are saved. Selecting this option will save all files including big Genome, SA and SAindex - this will create a complete genome directory");
        varOptions.setVariableGroup(ANNOTATIONS_OPTION);
        varOptions.setCommandParamater("--sjdbInsertSave All");
        this.jobDesc.addVariable(varOptions);
        this.createReadsOptions();
    }

    private void createReadsOptions() {
        String READ_PARAMETERS = "Read Parameters";
        VariableDescriptor varOptions = null;
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Read Map Number");
        varOptions.setHelpMsg("Number of reads to map from the beginning of the file, default -1 means map all reads. Default -1");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--readMapNumber");
        this.jobDesc.addVariable(varOptions);
        SelectionListVariableDescriptor varOptionsSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.setVariableName("Read Mates Lengths In");
        varOptionsSelectionList.setHelpMsg("are lengths of names,sequences,qualities for both mates are the same / not the same. NotEqual is safe in all situations. Default NotEqual");
        varOptionsSelectionList.addOptionValue("NotEqual", "NotEqual", "NotEqual/ not the same. NotEqual is safe in all situations");
        varOptionsSelectionList.addOptionValue("Equal", "Equal", "Equal/ are the same");
        varOptionsSelectionList.setVariableGroup(READ_PARAMETERS);
        varOptionsSelectionList.setCommandParamater("--readMatesLengthsIn");
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Read Name Separator");
        varOptions.setHelpMsg("Character(s) separating the part of the read names that will be trimmed in output (read name after space is always trimmed). Default /");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--readNameSeparator");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Clip 3p N bases");
        varOptions.setHelpMsg("Number(s) of bases to clip from 3p of each mate. If one value is given, it will be assumed the same for both mates. Default 0");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--clip3pNbases");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Clip 5p N bases");
        varOptions.setHelpMsg("number(s) of bases to clip from 5p of each mate. If one value is given, it will be assumed the same for both mates. Default 0");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--clip5pNbases");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Clip 3p Adapter Seq");
        varOptions.setHelpMsg("Adapter sequences to clip from 3p of each mate. If one value is given it will be assumed the same for both mates.");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--clip3pAdapterSeq");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Clip 3p Adapter max proportion of mismatches");
        varOptions.setHelpMsg("Max proportion of mismatches for 3p adpater clipping for each mate. If one value is given, it will be assumed the same for both mates. Default 0.1");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--clip3pAdapterMMp");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Clip 3p N bases After Adapter ");
        varOptions.setHelpMsg("Number of bases to clip from 3p of each mate after the adapter clipping. If one value is given, it will be assumed the same for both mates. Default 0");
        varOptions.setVariableGroup(READ_PARAMETERS);
        varOptions.setCommandParamater("--clip3pAfterAdapterNbases");
        this.jobDesc.addVariable(varOptions);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BAM_OUT), this.getVariable(OPTION_BAM_Sorted), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BAM_OUT), this.getVariable(OPTION_BAM_Unsorted), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
    }

    private void createIndexSection() {
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index");
        varIndexChioce.setHelpMsg("Use an exisiting index or create new one from a Fasta File");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable(varIndexChioce);
        VariableDescriptor varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Genome Index Directory");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing STAR referenece genome index folder");
        varUsedIndexFile.setHelpMsg("Directory where genome indices files are stored and genereted by STAR from prevoius runs.");
        varUsedIndexFile.setCommandParamater("--genomeDir");
        varUsedIndexFile.setSubProgName("_NO_CMD_");
        this.jobDesc.addVariable(varUsedIndexFile);
        VariableDescriptor varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Reference Fasta File");
        varIndexFile.setHelpMsg("Reference Fasta file with genome reference sequences to build a new index.");
        varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
        varIndexFile.setCommandParamater("--genomeFastaFiles");
        varIndexFile.setSubProgName("_NO_CMD_");
        this.jobDesc.addVariable(varIndexFile);
        VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.setVariableName("Genome directory");
        varIndexFilePrefix.setHelpMsg("Specifies path to the directory, where the genome indices are stored. The file system needs to have at least 100GB of diskspace available for a typical mammalian genome. It is recommended to remove all files from the genome directory before running the genome generation step. This directory path will be supplied at the mapping step to identify the reference genome. If not provided a directory will be created insided the job output folder.");
        varIndexFilePrefix.setCommandParamater("--genomeDir");
        varIndexFilePrefix.setSubProgName("_NO_CMD_");
        this.jobDesc.addVariable(varIndexFilePrefix);
    }

    protected void generateCommand(StringBuilder command) {
        String starCmd = String.valueOf(Constants.PIPELINE_BASE_PATH) + "STAR";
        String buildIndexDir = "indexDir";
        JobVariable buildIndex = this.getVariable(INPUT_INDEX_CHOICE);
        JobVariable buildIndexFastaFile = this.getVariable(INPUT_INDEX_FASTA_FILE);
        command.append(BashHelper.If((String)BashConditions.Equal((JobVariable)buildIndex, (String)"true")).Then(BashHelper.If((String)BashConditions.emptyStr((JobVariable)this.getVariable(INPUT_INDEX_PREFIX))).Then(String.valueOf(MappingSTARJob.st((String)BashHelper.assign((String)buildIndexDir, (String)BashHelper.Path.path((String)MappingSTARJob.$((String)"outputFolder"), (String)"geneomeDir")))) + MappingSTARJob.st((String)("mkdir -p " + MappingSTARJob.$((String)buildIndexDir)))).Else(MappingSTARJob.st((String)BashHelper.assign((String)buildIndexDir, (JobVariable)this.getVariable(INPUT_INDEX_PREFIX)))) + BashHelper.command_withTrack((String)buildIndexFastaFile.$(), (String)MappingSTARJob.st((String)(String.valueOf(starCmd) + "  --runMode genomeGenerate  --genomeDir " + MappingSTARJob.$((String)buildIndexDir) + " " + buildIndexFastaFile.getCMDParamaterValue())), (String)"STAR Index Build")).Else(MappingSTARJob.st((String)BashHelper.assign((String)buildIndexDir, (JobVariable)this.getVariable(INPUT_INDEX_FILE)))));
        String bamOutOption = "bamOutOption";
        String outFilePostfix = "outFilePostfix";
        command.append(String.valueOf(MappingSTARJob.st((String)BashHelper.assign((String)outFilePostfix, (String)"Aligned.out.sam"))) + BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(OPTION_BAM_OUT))).Then(String.valueOf(MappingSTARJob.st((String)BashHelper.assign((String)bamOutOption, (String)"--outSAMtype BAM"))) + MappingSTARJob.st((String)BashHelper.assign((String)outFilePostfix, (String)"Aligned.out.bam")) + BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(OPTION_BAM_Sorted))).Then(String.valueOf(MappingSTARJob.st((String)BashHelper.assign((String)bamOutOption, (String)(String.valueOf(MappingSTARJob.$((String)bamOutOption)) + " SortedByCoordinate")))) + MappingSTARJob.st((String)BashHelper.assign((String)outFilePostfix, (String)"Aligned.sortedByCoord.out.bam"))) + BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(OPTION_BAM_Unsorted))).Then(MappingSTARJob.st((String)BashHelper.assign((String)bamOutOption, (String)(String.valueOf(MappingSTARJob.$((String)bamOutOption)) + " SortedByCoordinate Unsorted"))))));
        FileListVariable inputFiles = (FileListVariable)this.getVariable(INPUT_FASTQ_FILE);
        command.append(BashHelper.Batcher_noLog((FileListVariable)inputFiles, (String)BashHelper.If((String)BashConditions.emptyStr((String)this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i"))).Then(MappingSTARJob.st((String)BashHelper.assign((String)"outputFileName", (String)"${inputFile1BaseName}"))).Else(MappingSTARJob.st((String)BashHelper.assign((String)"outputFileName", (String)this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i")))).toString(), (String)"", (String)BashHelper.If((String)BashConditions.emptyStr((String)this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i"))).Then(String.valueOf(MappingSTARJob.st((String)"outputFileName=$(hlp_lncName  \"$inputFile1BaseName\" \"$inputFile2BaseName\" )")) + MappingSTARJob.st((String)"[ -z \"${outputFileName}\" ] && outputFileName=\"${inputFile1BaseName}_${inputFile2BaseName}\"")).toString(), (String)(String.valueOf(this.getVariable(OUTPUT_LIBRARY_NAMES).getBashVarName("$_i")) + "=\"${outputFileName}\"\n" + this.getVariable(OUTPUT_BAM_FILES).getBashVarName("$_i") + "=\"${outputFolder}/${outputFileName}.${outFilePostfix}\"\n"), (boolean)true));
        command.append(BashHelper.BatcherParallel((FileListVariable)inputFiles, (String)(String.valueOf(MappingSTARJob.st((String)BashHelper.assign((String)"outputFileName", (String)this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i")))) + MappingSTARJob.st((String)("mkdir -p " + BashHelper.Path.path((String)MappingSTARJob.$((String)"outputFolder"), (String)"${outputFileName}")))), (String)"", (String)(String.valueOf(starCmd) + this.getOptionParamatersStrAs$() + MappingSTARJob.$((String)bamOutOption) + " --outFileNamePrefix \"${outputFolder}/${outputFileName}/${outputFileName}.\"  --genomeDir " + MappingSTARJob.$((String)buildIndexDir) + " --readFilesIn   ${_inputFile1}  \n"), (String)"", (String)(String.valueOf(starCmd) + this.getOptionParamatersStrAs$() + MappingSTARJob.$((String)bamOutOption) + " --outFileNamePrefix \"${outputFolder}/${outputFileName}/${outputFileName}.\"  --genomeDir " + MappingSTARJob.$((String)buildIndexDir) + " --readFilesIn   ${_inputFile1} ${_inputFile2}  \n"), (String)BashHelper.moveWithWarning((String)BashHelper.Path.path((String)MappingSTARJob.$((String)"outputFolder"), (String)"${outputFileName}/${outputFileName}.${outFilePostfix}"), (String)BashHelper.Path.path((String)MappingSTARJob.$((String)"outputFolder"), (String)"${outputFileName}.${outFilePostfix}"))));
    }
}

