/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class BedToJuncsJob
extends ISWFJob {
    public static final String JOB_ID = "bed_to_juncs";
    public static final String JOB_NAME = "Bed to junctions";
    public static final String OUTPUT_JUNCS_FILES = "OUTPUT_JUNCS_FILES";

    public BedToJuncsJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("bed to juncs script : is a tophat component to convert junctions in BED format produced by TopHat to the internal .juncs format for re-use with future runs.\nIn which the Junctions are specified one per line, in a tab-delimited format.\nRecords look like:\n<chrom> <left> <right> <+/->");
        this.jobDesc.addPublication(new Publication().setTitle("Kim D, Pertea G, Trapnell C, Pimentel H, Kelley R and Salzberg SL. 2013. \"TopHat2: Accurate Alignment of Transcriptomes in the Presence of Insertions, Deletions and Gene Fusions.\" Genome Biology 14 (4): R36").setDOI("doi:10.1186/gb-2013-14-4-r36").setPubmed("23618408"));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input junctions bed file");
        varReadInputFile.setHelpMsg("Input junctions bed file, this files are an output from Tophat tools.");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_JUNCS_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Output Juncs File");
        bamOutputFile.setHelpMsg("Output Juncs File");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = JOB_ID;
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable("INPUT_FILES");
        FilesVariable outputBamFilesVar = (FilesVariable)this.getVariable(OUTPUT_JUNCS_FILES);
        builder.append(BedToJuncsJob.st((String)"_ext=\"juncs\""));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)BedToJuncsJob.st((String)BashHelper.arrayAdd((JobVariable)outputBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.${_ext}")), (String)(String.valueOf(cmdPrefix) + this.getOptionParamatersStrAs$() + " < ${_inputFile}  > " + outputBamFilesVar.$("${_i}")), (String)JOB_ID));
    }
}

