/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs;

import com.biotechvana.workflow.descriptors.DescFilters;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class PreprocessingFilters {
    private static final String GROUP_FILTERS = "Filters";
    public static final String FILTER_OPT_Q = "Q_Filter";
    public static final String FILTER_OPT_QP = "QP_ARG";
    public static final String FILTER_OPT_SC = "SC_Filter";
    public static final String FILTER_OPT_GC = "GC_Filter";
    public static final String FILTER_OPT_OS = "OS_Filter";
    public static final String FILTER_OPT_AC = "AC_Filter";
    public static final String FILTER_OPT_KC = "KC_Filter";
    public static String MAPPING_QC_OAR = "QC-OAR";
    public static String MAPPING_Extractor_OAR = "Overall Alignment Rate";

    private static VariableDescriptor createFastqcReports() {
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_REPORT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Reports");
        varOutputFiles.addAcceptedFileFormat("ZIP");
        return varOutputFiles;
    }

    private static DescFilters.JobDescriptorFilterExtractor createFastqcReportsTransformer(JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor qcF = new DescFilters.JobDescriptorFilterExtractor("Extract QC from Output Fastq/Bam files");
        qcF.setCMDScript("fastqc");
        VariableDescriptor reportFiles = PreprocessingFilters.createFastqcReports();
        validationJobDesc.addVariable(reportFiles);
        qcF.setInputVariable(varOutputFiles);
        qcF.setStoreVariable(reportFiles);
        return qcF;
    }

    public static void addPrepresoccesingFilter(JobDescriptor targetJobDesc, VariableDescriptor varOutputFiles) {
        JobDescriptor validationJobDesc = new JobDescriptor(String.valueOf(targetJobDesc.jobId) + "_validation");
        DescFilters.JobDescriptorFilterExtractor qcF = PreprocessingFilters.createFastqcReportsTransformer(validationJobDesc, varOutputFiles);
        targetJobDesc.addExtractor(qcF);
        PreprocessingFilters.createPerBaseQualityScoreEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerSequenceMeanQualityScoreEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerContentQVariance5EndEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerContentKmer5EndEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerContentQVariance3EndEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerContentKmer3EndEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerSequenceGCContentStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPerBaseNContentStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createSequenceDuplicationLevelsStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createOverrepresentedSequencesStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createAdapterContentStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createPercentAdapterContentStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createKmerContentStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
        PreprocessingFilters.createNTotalFailedStatusEF(targetJobDesc, validationJobDesc, qcF.getStoreVariable());
    }

    private static void createPerBaseQualityScoreEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Min Quality Score Q Per BPQ (base positions percet)");
        extractor_QBP.setDesc("Extract Mean average Quality score for the target percent of base positions: Mean Average Quality Score in the [100-BPQ] percentile ");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"base_positions_percet", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("Percent of Positions BP:");
        extractorArg.setHelpMsg("Percent of Positions [BP] that should have min quality score of [Q]");
        extractorArg.setCommandParamater("--bp");
        validationJobDesc.addVariable(extractorArg);
        extractor_QBP.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"BPQ", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Min Q quality score in the givin Percent of Positions BP");
        storeVariable.setHelpMsg("Min Quality score of Q  of BP of positions extracted from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"BPQ_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Min per base quality Score - Q");
        filterOption.setHelpMsg("Min Quality score of Q  that should the BP of positions have");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_QBP = new DescFilters.JobDescriptorThresholdFilter();
        QC_QBP.setName("QC-QBP");
        QC_QBP.setDesc("Per base quality Score - Q in BP");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.LessThan);
        QC_QBP.setThresholdVariable(filterOption);
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createPerSequenceGCContentStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Per Sequence GC content Status");
        extractor_QBP.setDesc("Extract Per Sequence GC content Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"PSGC_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Per Sequence GC content Status");
        storeVariable.setHelpMsg("Per Sequence GC content Status from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-PSGC_STATUS");
        QC_QBP.setDesc("PSGC_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createPerBaseNContentStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Per Base N content Status");
        extractor_QBP.setDesc("Extract Per Base N content Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"PBN_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Per Base N content Status");
        storeVariable.setHelpMsg("Per Base N content Status from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-PBN_STATUS");
        QC_QBP.setDesc("PBN_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createSequenceDuplicationLevelsStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Sequence duplication levels Status");
        extractor_QBP.setDesc("Extract Sequence duplication levels Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"SDL_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Sequence duplication levels Status");
        storeVariable.setHelpMsg("Sequence duplication levels from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-SDL_STATUS");
        QC_QBP.setDesc("SDL_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createOverrepresentedSequencesStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Overrepresented sequences checkStatus");
        extractor_QBP.setDesc("Extract Overrepresented sequences  Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"ORS_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Overrepresented sequences Status");
        storeVariable.setHelpMsg("Overrepresented sequences from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-ORS_STATUS");
        QC_QBP.setDesc("ORS_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createAdapterContentStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Adapter Content Status");
        extractor_QBP.setDesc("Extract Adapter Content Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"ADC_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Adapter Content Status");
        storeVariable.setHelpMsg("Adapter Content Status from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-ADC_STATUS");
        QC_QBP.setDesc("ADC_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createPercentAdapterContentStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Percent of Adapter Content Status");
        extractor_QBP.setDesc("Extract Percent of Adapter Content Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"PADC_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Percent of Adapter Content Status");
        storeVariable.setHelpMsg("Percent of Adapter Content Status from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-PADC_STATUS");
        QC_QBP.setDesc("PADC_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createKmerContentStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor_QBP = new DescFilters.JobDescriptorFilterExtractor("Kmer Content Status");
        extractor_QBP.setDesc("Extract Kmer Content Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"KMC_STATUS", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Kmer Content Status");
        storeVariable.setHelpMsg("Kmer Content Status from fastqc report");
        extractor_QBP.setStoreVariable(storeVariable);
        extractor_QBP.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorStatusFilter QC_QBP = new DescFilters.JobDescriptorStatusFilter();
        QC_QBP.setName("QC-KMC_STATUS");
        QC_QBP.setDesc("KMC_STATUS");
        QC_QBP.setComparisonOperator(DescFilters.FCExpressionOperator.Equal);
        QC_QBP.setStatusValue("fail");
        QC_QBP.setTargetVaraible(extractor_QBP.getStoreVariable());
        targetJobDesc.addExtractor(extractor_QBP);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_QBP);
    }

    private static void createPerSequenceMeanQualityScoreEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Min Quality Score Q Per percent of reads RP");
        extractor.setDesc("Extract Mean average Quality score for the target percent of reads");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"reads_percet", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("Percent of reads:");
        extractorArg.setHelpMsg("Percent of reads [RP] that should have min quality score of [Q]");
        extractorArg.setDefaultValue("50");
        extractorArg.setCommandParamater("--rp");
        validationJobDesc.addVariable(extractorArg);
        extractor.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"RPQ", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Min Q quality score in the givin RP");
        storeVariable.setHelpMsg("Min Quality score of Q of Percent of reads [RP] extracted from fastqc report");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"RPQ_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Min Per sequence quality Score - Q");
        filterOption.setHelpMsg("Min Quality score of Q  that should the RP of reads have");
        filterOption.setDefaultValue("20");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-QRP");
        QC_Filter.setDesc("Per sequence quality Score - Q in RP");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.LessThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    private static void createNTotalFailedStatusEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Total Passed QC Status");
        extractor.setDesc("Extract number of passed QC Status");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"NP_Status", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Number of Passed QC Status");
        storeVariable.setHelpMsg("Number of Passed QC Status out of 11 status");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"NP_Status_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Min number of NP_Status to pass");
        filterOption.setHelpMsg("Min number of NP_Status to pass");
        filterOption.setDefaultValue("5");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-NP_Status");
        QC_Filter.setDesc("NP_Status");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.LessThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    private static void createPerContentQVariance5EndEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Quality Score Q Variance across reads in N5End first Bases");
        extractor.setDesc("Quality Score Q Variance across reads in N5End first Bases");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"N5End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("N5End");
        extractorArg.setHelpMsg("Number of bases from 5'end to look at");
        extractorArg.setDefaultValue("8");
        extractorArg.setCommandParamater("--n5end");
        validationJobDesc.addVariable(extractorArg);
        extractor.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"QVinN5End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Q Variance First N bases in 5'end");
        storeVariable.setHelpMsg("Q Variance First N bases in 5'end extracted from fastqc report");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"QVinN5_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max quality score variance expected in First N bases from 5'end");
        filterOption.setHelpMsg("Max quality score variance expected in First N bases from 5'end");
        filterOption.setDefaultValue("4");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-QVN5");
        QC_Filter.setDesc("per content quality Score - QVN5");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.GreaterThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    private static void createPerContentQVariance3EndEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Quality Score Q Variance across reads in N3End first Bases");
        extractor.setDesc("Quality Score Q Variance across reads in N3End first Bases");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"N3End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("N3End");
        extractorArg.setHelpMsg("Number of bases from 3'end to look at");
        extractorArg.setDefaultValue("3");
        extractorArg.setCommandParamater("--n3end");
        validationJobDesc.addVariable(extractorArg);
        extractor.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"QVinN3End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("Q Variance First N bases in 3'end");
        storeVariable.setHelpMsg("Q Variance First N bases in 3'end extracted from fastqc report");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"QVinN3_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max quality score variance expected in First N bases from 3'end");
        filterOption.setHelpMsg("Max quality score variance expected in First N bases from 3'end");
        filterOption.setDefaultValue("4");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-QVN3");
        QC_Filter.setDesc("per content quality Score - QVN3");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.GreaterThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    private static void createPerContentKmer5EndEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Quality Score Q Variance across reads in N5End first Bases");
        extractor.setDesc("Quality Score Q Variance across reads in N5End first Bases");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"N5End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("N5End");
        extractorArg.setHelpMsg("Number of bases from 5'end to look at");
        extractorArg.setDefaultValue("8");
        extractorArg.setCommandParamater("--n5end");
        validationJobDesc.addVariable(extractorArg);
        extractor.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"KmerinN5End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("log2 obs/Exp value of kmer content in First N bases in 5'end");
        storeVariable.setHelpMsg("Log2 obs/Exp value of kmer content in First N bases in 5'end extracted from fastqc report");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"LGKinN5_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max Log2 obs/Exp value of kmer content in First N bases from 5'end");
        filterOption.setHelpMsg("Max Log2 obs/Exp value of kmer content in First N bases from 5'end");
        filterOption.setDefaultValue("4");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-LGKN5");
        QC_Filter.setDesc("kmer content - LGKN5");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.GreaterThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    private static void createPerContentKmer3EndEF(JobDescriptor targetJobDesc, JobDescriptor validationJobDesc, VariableDescriptor varOutputFiles) {
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Quality Score Q Variance across reads in N3End first Bases");
        extractor.setDesc("Quality Score Q Variance across reads in N3End first Bases");
        VariableDescriptor extractorArg = VariableDescriptor.createDescriptorFor((String)"N3End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        extractorArg.setVariableName("N3End");
        extractorArg.setHelpMsg("Number of bases from 3'end to look at");
        extractorArg.setDefaultValue("3");
        extractorArg.setCommandParamater("--n3end");
        validationJobDesc.addVariable(extractorArg);
        extractor.addArg(extractorArg);
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"KmerinN3End", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("log2 obs/Exp value of kmer content in First N bases in 3'end");
        storeVariable.setHelpMsg("Log2 obs/Exp value of kmer content in First N bases in 3'end extracted from fastqc report");
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)"LGKinN3_Threshold", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max Log2 obs/Exp value of kmer content in First N bases from 3'end");
        filterOption.setHelpMsg("Max Log2 obs/Exp value of kmer content in First N bases from 3'end");
        filterOption.setDefaultValue("4");
        validationJobDesc.addVariable(filterOption);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-LGKN3");
        QC_Filter.setDesc("kmer content - LGKN3");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.GreaterThan);
        QC_Filter.setThresholdVariable(filterOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    public static void addPrepresoccesingPRFilter(JobDescriptor targetJobDesc, VariableDescriptor varOutputFiles, VariableDescriptor varPROption) {
        JobDescriptor validationJobDesc = new JobDescriptor(String.valueOf(targetJobDesc.jobId) + "_p_validation");
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor("Good reads percent");
        extractor.setDesc("Good reads percent");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"good_read_percent", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("good_read_percent after preprocessing");
        storeVariable.setHelpMsg("good_read_percent after preprocessing");
        validationJobDesc.addVariable(storeVariable);
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName("QC-PR");
        QC_Filter.setDesc("Good read precent");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.LessThan);
        QC_Filter.setThresholdVariable(varPROption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
    }

    public static JobDescriptor addPrepresoccesingRMFilter(JobDescriptor targetJobDesc, VariableDescriptor varOutputFiles, VariableDescriptor varRMOption) {
        JobDescriptor validationJobDesc = targetJobDesc;
        DescFilters.JobDescriptorFilterExtractor extractor = new DescFilters.JobDescriptorFilterExtractor(MAPPING_Extractor_OAR);
        extractor.setDesc("Overall alignment rate");
        VariableDescriptor storeVariable = VariableDescriptor.createDescriptorFor((String)"alignment_rate", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        storeVariable.setVariableName("alignment_rate after mapping");
        storeVariable.setHelpMsg("alignment_rate after mapping");
        validationJobDesc.addVariable(storeVariable);
        extractor.setStoreVariable(storeVariable);
        extractor.setInputVariable(varOutputFiles);
        DescFilters.JobDescriptorThresholdFilter QC_Filter = new DescFilters.JobDescriptorThresholdFilter();
        QC_Filter.setName(MAPPING_QC_OAR);
        QC_Filter.setDesc("Overall alignment rate");
        QC_Filter.setComparisonOperator(DescFilters.FCExpressionOperator.LessThan);
        QC_Filter.setThresholdVariable(varRMOption);
        QC_Filter.setTargetVaraible(extractor.getStoreVariable());
        targetJobDesc.addExtractor(extractor);
        targetJobDesc.addThresholdFilter((DescFilters.JobDescriptorFilterBase)QC_Filter);
        return validationJobDesc;
    }
}

