/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking.tasks;

import com.biotechvana.workflow.executer.CMLTemplate;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.events.CMDInfoTrackEvent;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingFinishedTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import com.biotechvana.workflow.tracking.events.VarInfoTrackEvent;
import com.biotechvana.workflow.tracking.tasks.WorkflowJobTracker;
import java.util.ArrayList;
import java.util.List;

public class CMDTaskTracker {
    boolean batchFiles = true;
    String taskName;
    String taskId;
    WorkflowJobTracker workflowJobTracker;
    CMLTemplate orgTemplate;
    VarInfoTrackEvent infoVar;
    private String varKey;
    ArrayList<FilesTask> taskPerFile = new ArrayList();

    public CMDTaskTracker(WorkflowJobTracker workflowJobTracker) {
        this.workflowJobTracker = workflowJobTracker;
    }

    public String getLog(FilesTask filesTask) {
        if (filesTask.getStartEvent() != null && this.workflowJobTracker != null) {
            return this.workflowJobTracker.getLog(filesTask.getStartEvent());
        }
        return "";
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
        if (this.taskId == null) {
            this.taskId = taskName;
        }
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void addTrackerVariables(String varKey) {
        this.varKey = varKey;
    }

    public void addVarTrackerInfo(VarInfoTrackEvent infoVar) {
        this.infoVar = infoVar;
        if (infoVar != null) {
            this.varKey = infoVar.getVariableKey();
        }
    }

    public void addBlockInfo(List<ITrackerInfo> entries) {
        FilesTask filesTask = new FilesTask();
        for (ITrackerInfo o : entries) {
            if (o instanceof ProcessingTrackEvent) {
                filesTask.startEvent = (ProcessingTrackEvent)o;
                filesTask.files = filesTask.startEvent.getFileList();
                continue;
            }
            if (o instanceof ProcessingFinishedTrackEvent) {
                filesTask.finshEvent = (ProcessingFinishedTrackEvent)o;
                continue;
            }
            filesTask.otherEvents.add(o);
        }
        this.taskPerFile.add(filesTask);
        String file_index_key = this.workflowJobTracker.filesToIndex(filesTask.files);
        WorkflowJobTracker.VariableIndex variableIndex = this.workflowJobTracker.fileVarIndex.get(file_index_key);
        filesTask.index = variableIndex == null ? this.taskPerFile.size() : variableIndex.index;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int nOfTasks() {
        return this.taskPerFile.size();
    }

    public WorkflowJobTracker getTracker() {
        return this.workflowJobTracker;
    }

    public ArrayList<FilesTask> getCmdTasks() {
        return this.taskPerFile;
    }

    public ExecStatus getStatus() {
        boolean failed = false;
        for (FilesTask filesTask : this.taskPerFile) {
            if (filesTask.getStatus() == ExecStatus.Finished) continue;
            failed = true;
        }
        if (failed) {
            return ExecStatus.Failed;
        }
        return ExecStatus.Finished;
    }

    public String getVarKey() {
        return this.varKey;
    }

    public class FilesTask {
        private ProcessingTrackEvent startEvent;
        ProcessingFinishedTrackEvent finshEvent;
        InfoTrackEvent mainInfo;
        ArrayList<ITrackerInfo> otherEvents = new ArrayList();
        ArrayList<ArrayList<String>> files;
        public int index = 0;

        public String[] toTreeList() {
            return new String[]{"#"};
        }

        public CMDTaskTracker getCMDTaskTracker() {
            return CMDTaskTracker.this;
        }

        public String getTitle() {
            return "#" + this.index + ": " + this.startEvent.getFiles();
        }

        public ExecStatus getStatus() {
            ExecStatus execStatus = ExecStatus.Unknown;
            if (this.finshEvent == null) {
                if (CMDTaskTracker.this.workflowJobTracker.entry.getStatus() == ExecStatus.Canceled) {
                    return ExecStatus.Canceled;
                }
                return ExecStatus.Unknown;
            }
            execStatus = this.finshEvent.getExecStatus();
            for (ITrackerInfo o : this.otherEvents) {
                if (!(o instanceof CMDInfoTrackEvent) || o.getExecStatus() == ExecStatus.Finished) continue;
                execStatus = ExecStatus.Failed;
            }
            return execStatus;
        }

        public ProcessingTrackEvent getStartEvent() {
            return this.startEvent;
        }

        public List<ITrackerInfo> getEvents() {
            return this.otherEvents;
        }

        public TrackerInfoEntry getFinshEvent() {
            return this.finshEvent;
        }

        public String getLog() {
            return CMDTaskTracker.this.getLog(this);
        }
    }
}

