/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.submissionhistory.RawTrackingLogEntry;
import com.biotechvana.workflow.submissionhistory.TaskLogFile;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.UITaskTrackInfo;
import com.biotechvana.workflow.tracking.events.EndTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingFinishedTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;

public class TrackInfo
implements ITrackerInfo {
    TrackInfo parent = null;
    private long scriptStartTime;
    private long scriptStopTime = -1L;
    private long lastTimeUpdated = -1L;
    private String taskName;
    private long scriptProcessID = -1L;
    List<ITrackerInfo> entries;
    private ExecStatus execStatus = ExecStatus.Unknown;
    private boolean anyFailed = false;
    private String logMsg = "";
    private String endLogMsg;
    TaskLogFile taskLogFile = null;

    public List<ITrackerInfo> getTrackerInfoEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ITrackerInfo>();
        }
        return this.entries;
    }

    private void addTrackerInfo(ITrackerInfo info) {
        try {
            if (info instanceof TrackerInfoEntry) {
                TrackerInfoEntry entry = (TrackerInfoEntry)info;
                this.addEntry(entry);
            }
            if (info instanceof TrackInfo) {
                TrackInfo trackerInfo = (TrackInfo)info;
                this.addEntry(trackerInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addEntry(TrackInfo trackerInfo) {
        this.getTrackerInfoEntries();
        if (trackerInfo.getExecStatus() != ExecStatus.Finished) {
            this.setExecStatus(trackerInfo.getExecStatus());
        }
        this.lastTimeUpdated = trackerInfo.getLastTimeUpdated();
        trackerInfo.parent = this;
        this.entries.add(trackerInfo);
    }

    private void setScriptStopTime(long stopTime) {
        this.scriptStopTime = stopTime;
        this.lastTimeUpdated = stopTime;
    }

    private void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    private static TrackInfo from(String[] firstEvent, List<String[]> currentBlockOfTokens) {
        return TrackInfo.from(firstEvent, null, currentBlockOfTokens);
    }

    private void addEntry(TrackerInfoEntry entry) {
        this.getTrackerInfoEntries();
        if (entry.getEventtype() == Tracking.TrackEventType.Started) {
            this.execStatus = ExecStatus.Running;
        }
        if (entry.getEventtype() == Tracking.TrackEventType.Ended) {
            EndTrackEvent endEvent = (EndTrackEvent)entry;
            if (endEvent.getEndStatus() == Tracking.TrackEndStatus.Failed) {
                this.execStatus = ExecStatus.Finished;
            } else if (endEvent.getEndStatus() == Tracking.TrackEndStatus.Finished) {
                this.execStatus = ExecStatus.Finished;
            } else if (endEvent.getEndStatus() == Tracking.TrackEndStatus.Warning) {
                this.execStatus = ExecStatus.Warning;
            }
        }
        if (entry.getEventtype() == Tracking.TrackEventType.Failed) {
            this.execStatus = ExecStatus.Failed;
        }
        if (entry.getEventtype() == Tracking.TrackEventType.ProcessingFail) {
            this.anyFailed = true;
        }
        if (entry.getEventtype() == Tracking.TrackEventType.Paused) {
            this.execStatus = ExecStatus.Paused;
        }
        if (entry.getEventtype() == Tracking.TrackEventType.Resumed) {
            this.execStatus = ExecStatus.Running;
        }
        if (entry.getEventtype() == Tracking.TrackEventType.Canceled) {
            this.execStatus = ExecStatus.Canceled;
        }
        this.lastTimeUpdated = entry.getStartTime();
        this.entries.add(entry);
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        Object preTab = "";
        int i = 0;
        while (i < level) {
            preTab = (String)preTab + "\t";
            ++i;
        }
        String res = (String)preTab + this.scriptStartTime + " \t" + this.scriptStopTime + "\t" + this.taskName + "\tT\n";
        res = res + (String)preTab + "------------------\n";
        for (ITrackerInfo info : this.getTrackerInfoEntries()) {
            res = res + info.toString(level + 1);
        }
        return res + "\n";
    }

    public String toTrackInfo() {
        if (this.taskName == null) {
            return "";
        }
        return this.toTrackInfo(0);
    }

    @Override
    public String toTrackInfo(int level) {
        Object preTab = "";
        int i = 0;
        while (i < level) {
            preTab = (String)preTab + "\t";
            ++i;
        }
        String timeStamp = new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.scriptStartTime * 1000L));
        String res = (String)preTab + "[" + timeStamp + "]\t" + this.taskName + " Started\n";
        for (ITrackerInfo info : this.getTrackerInfoEntries()) {
            res = res + info.toTrackInfo(level + 1);
        }
        if (this.execStatus == ExecStatus.Failed) {
            res = res + (String)preTab + "[" + timeStamp + "]\t" + this.taskName + " Failed\n";
        }
        if (this.execStatus == ExecStatus.Finished) {
            timeStamp = new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.getStopTime() * 1000L));
            res = res + (String)preTab + "[" + timeStamp + "]\t" + this.taskName + " Finished\n";
        }
        return res + "\n";
    }

    public ITrackerInfo getSubInfoByTaskName(String jobDescID) {
        for (ITrackerInfo info : this.getTrackerInfoEntries()) {
            if (!info.getTaskName().equals(jobDescID)) continue;
            return info;
        }
        return null;
    }

    private void setExecStatus(ExecStatus running) {
        this.execStatus = running;
    }

    protected void updateStatus() {
    }

    @Override
    public ExecStatus getExecStatus() {
        if (this.anyFailed) {
            return ExecStatus.Failed;
        }
        return this.execStatus;
    }

    private void setScriptStartTime(long startTime) {
        this.scriptStartTime = startTime;
        this.lastTimeUpdated = startTime;
    }

    public long getScriptStartTime() {
        return this.scriptStartTime;
    }

    private void setPID(long pid) {
        this.scriptProcessID = pid;
    }

    public long getScriptPID() {
        return this.scriptProcessID;
    }

    @Override
    public String getTime() {
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.scriptStartTime * 1000L));
    }

    public String getFinishTime() {
        return new SimpleDateFormat("dd-MM-YYYY  HH:mm:ss").format(new Date(this.scriptStopTime * 1000L));
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setLogMsg(String logMsg) {
        this.logMsg = logMsg;
    }

    @Override
    public String getLogMsg() {
        return this.getLogMsg(null);
    }

    public String getLogMsg(ProcessingTrackEvent startEvent) {
        if (this.taskLogFile == null) {
            return this.logMsg;
        }
        return this.taskLogFile.getLogMsg(startEvent);
    }

    public String getEndLogMsg() {
        return this.endLogMsg;
    }

    public long getStopTime() {
        return this.scriptStopTime;
    }

    public long getLastTimeUpdated() {
        return this.lastTimeUpdated;
    }

    public static TrackInfo loadFromFile(File trackFile) {
        TrackInfo info = new TrackInfo();
        info.setExecStatus(ExecStatus.Unknown);
        if (trackFile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(trackFile));
                try {
                    String line = br.readLine();
                    if (line == null) {
                        br.close();
                        throw new IOException("Track file is empty -- Must be a problem with running the script");
                    }
                    String[] tokens = line.split("\t");
                    if (Tracking.TrackEventType.valueOf(tokens[1]) == Tracking.TrackEventType.Started) {
                        try {
                            info.setPID(Long.parseLong(tokens[2].trim()));
                        }
                        catch (Exception ex) {
                            info.setPID(-1L);
                            ex.printStackTrace();
                        }
                        info.setScriptStartTime(Long.parseLong(tokens[0]));
                        info.setExecStatus(ExecStatus.Running);
                    }
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        tokens = line.split("\t");
                        TrackerInfoEntry entry = TrackerInfoEntry.from(tokens);
                        info.addEntry(entry);
                    }
                    br.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return info;
    }

    public static TrackInfo loadFromFile_nested(File trackFile) {
        ArrayList<String[]> linesTokens = new ArrayList<String[]>();
        if (trackFile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(trackFile));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        String[] tokens = line.split("\t");
                        linesTokens.add(tokens);
                    }
                    br.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        TrackInfo info = null;
        if (linesTokens.size() > 0) {
            try {
                info = (TrackInfo)TrackInfo.getITrackInfos(linesTokens).get(0);
            }
            catch (Exception ex) {
                info = null;
                ex.printStackTrace();
                System.err.println("Can not parse track file " + trackFile.getAbsolutePath());
            }
        }
        if (info == null) {
            info = new TrackInfo();
        }
        return info;
    }

    private static List<ITrackerInfo> getITrackInfos(List<String[]> linesTokens) {
        ArrayList<ITrackerInfo> list = new ArrayList<ITrackerInfo>();
        ArrayList<String[]> currentBlockOfTokens = new ArrayList<String[]>();
        Stack<String> stack = new Stack<String>();
        int i = 0;
        while (i < linesTokens.size()) {
            String[] tokens = linesTokens.get(i);
            currentBlockOfTokens.add(tokens);
            if (tokens.length > 1 && Tracking.TrackEventType.valueOf(tokens[1].trim()) == Tracking.TrackEventType.Started) {
                stack.push(tokens[2]);
            }
            if (tokens.length > 1 && (Tracking.TrackEventType.valueOf(tokens[1].trim()) == Tracking.TrackEventType.Failed || Tracking.TrackEventType.valueOf(tokens[1].trim()) == Tracking.TrackEventType.Ended) && !stack.isEmpty() && tokens[2].trim().equals(((String)stack.peek()).trim())) {
                stack.pop();
            }
            if (stack.isEmpty()) {
                if (currentBlockOfTokens.size() == 1) {
                    try {
                        TrackerInfoEntry eventEntry = TrackerInfoEntry.from((String[])currentBlockOfTokens.get(0));
                        list.add(eventEntry);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    String[] firstEvent = (String[])currentBlockOfTokens.get(0);
                    String[] lastEvent = (String[])currentBlockOfTokens.get(currentBlockOfTokens.size() - 1);
                    currentBlockOfTokens.remove(0);
                    currentBlockOfTokens.remove(currentBlockOfTokens.size() - 1);
                    TrackInfo newInfo = TrackInfo.from(firstEvent, lastEvent, currentBlockOfTokens);
                    list.add(newInfo);
                }
                currentBlockOfTokens.clear();
            }
            ++i;
        }
        if (!currentBlockOfTokens.isEmpty()) {
            String[] firstEvent = (String[])currentBlockOfTokens.get(0);
            currentBlockOfTokens.remove(0);
            TrackInfo newInfo = TrackInfo.from(firstEvent, currentBlockOfTokens);
            list.add(newInfo);
            currentBlockOfTokens.clear();
        }
        return list;
    }

    private static TrackInfo from(String[] firstEvent, String[] lastEvent, List<String[]> currentBlockOfTokens) {
        TrackInfo trackInfo = new TrackInfo();
        trackInfo.setExecStatus(ExecStatus.Unknown);
        trackInfo.setTaskName(firstEvent[2]);
        if (firstEvent.length > 3) {
            try {
                trackInfo.setPID(Long.parseLong(firstEvent[3].trim()));
            }
            catch (Exception ex) {
                trackInfo.setPID(-1L);
                ex.printStackTrace();
            }
        }
        trackInfo.setScriptStartTime(Long.parseLong(firstEvent[0].split("\\$")[0].trim()));
        trackInfo.setExecStatus(ExecStatus.Running);
        List<ITrackerInfo> list = TrackInfo.getITrackInfos(currentBlockOfTokens);
        for (ITrackerInfo info : list) {
            trackInfo.addTrackerInfo(info);
        }
        if (lastEvent != null) {
            trackInfo.setScriptStopTime(Long.parseLong(lastEvent[0].split("\\$")[0].trim()));
            if (Tracking.TrackEventType.valueOf(lastEvent[1]) == Tracking.TrackEventType.Ended) {
                if (lastEvent.length > 3) {
                    String endLogMsg = lastEvent[2] + " has finished running.";
                    Tracking.TrackEndStatus status = Tracking.TrackEndStatus.valueOf(lastEvent[3]);
                    String msg = "";
                    if (lastEvent.length > 4) {
                        msg = lastEvent[4];
                    }
                    if (status == Tracking.TrackEndStatus.Failed) {
                        trackInfo.setExecStatus(ExecStatus.Failed);
                        endLogMsg = lastEvent[2] + " has Failed." + msg;
                    } else if (status == Tracking.TrackEndStatus.Finished) {
                        trackInfo.setExecStatus(ExecStatus.Finished);
                    } else if (status == Tracking.TrackEndStatus.Warning) {
                        trackInfo.setExecStatus(ExecStatus.Warning);
                        endLogMsg = lastEvent[2] + " has Finished with some warning. " + msg;
                    }
                    trackInfo.endLogMsg = endLogMsg;
                } else {
                    trackInfo.setExecStatus(ExecStatus.Finished);
                }
            }
            if (Tracking.TrackEventType.valueOf(lastEvent[1]) == Tracking.TrackEventType.Failed) {
                trackInfo.setExecStatus(ExecStatus.Failed);
            }
        }
        return trackInfo;
    }

    public void setTest() {
    }

    @Override
    public String getPID() {
        return "" + this.scriptProcessID;
    }

    @Override
    public String getPPID() {
        return null;
    }

    public void setTaskLog(TaskLogFile taskLogFile) {
        this.taskLogFile = taskLogFile;
    }

    public TaskLogFile getTaskLog() {
        return this.taskLogFile;
    }

    public List<RawTrackingLogEntry> getRawTrackingLogEntries() {
        ArrayList<RawTrackingLogEntry> entries = new ArrayList<RawTrackingLogEntry>();
        RawTrackingLogEntry taskInfos = new RawTrackingLogEntry();
        taskInfos.time = this.getTime();
        taskInfos.msg = "Start Running : " + this.getTaskName() + ". ";
        taskInfos.type = Tracking.TrackEventType.Started;
        if (this.getScriptPID() != -1L) {
            taskInfos.msg = String.valueOf(taskInfos.msg) + "With pid : " + this.getScriptPID();
        }
        if (this.getTaskName() != null) {
            entries.add(taskInfos);
        }
        List<ITrackerInfo> trackerInfoEntries = this.getTrackerInfoEntries();
        int i = 0;
        while (i < trackerInfoEntries.size()) {
            ITrackerInfo trackerInfo = trackerInfoEntries.get(i);
            if (trackerInfo instanceof TrackerInfoEntry) {
                if (((TrackerInfoEntry)trackerInfo).getEventtype() != Tracking.TrackEventType.Info) {
                    taskInfos = new RawTrackingLogEntry();
                    taskInfos.time = trackerInfo.getTime();
                    taskInfos.msg = trackerInfo.getLogMsg();
                    taskInfos.type = ((TrackerInfoEntry)trackerInfo).getEventtype();
                    taskInfos.entry = (TrackerInfoEntry)trackerInfo;
                    entries.add(taskInfos);
                }
            } else if (trackerInfo instanceof TrackInfo) {
                List<RawTrackingLogEntry> sublist = ((TrackInfo)trackerInfo).getRawTrackingLogEntries();
                entries.addAll(sublist);
            }
            ++i;
        }
        if (this.getExecStatus() == ExecStatus.Failed) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = this.getTime();
            taskInfos.msg = this.getTaskName() + " has failed.";
            taskInfos.msg = this.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Failed;
            entries.add(taskInfos);
        }
        if (this.getExecStatus() == ExecStatus.Finished) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = this.getTime();
            taskInfos.msg = this.getTaskName() + " has Finished.";
            taskInfos.msg = this.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Ended;
            entries.add(taskInfos);
        }
        if (this.getExecStatus() == ExecStatus.Warning) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = this.getTime();
            taskInfos.msg = this.getTaskName() + " has Finished With Warning.";
            taskInfos.msg = this.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Ended;
            entries.add(taskInfos);
        }
        return entries;
    }

    public List<UITaskTrackInfo> getUITaskTrackInfos() {
        ArrayList<UITaskTrackInfo> entries = new ArrayList<UITaskTrackInfo>();
        List<ITrackerInfo> trackerInfoEntries = this.getTrackerInfoEntries();
        int i = 0;
        while (i < trackerInfoEntries.size()) {
            ITrackerInfo trackerInfo = trackerInfoEntries.get(i);
            if (trackerInfo instanceof TrackerInfoEntry) {
                if (trackerInfo instanceof ProcessingTrackEvent) {
                    taskInfos = new UITaskTrackInfo();
                    taskInfos.startTime = trackerInfo.getTime();
                    taskInfos.files = ((ProcessingTrackEvent)trackerInfo).getFiles();
                    taskInfos.info = ((ProcessingTrackEvent)trackerInfo).getDesc();
                    taskInfos.status = "Processing";
                    if (this.getExecStatus() == ExecStatus.Canceled) {
                        taskInfos.status = "Canceled";
                    }
                    taskInfos.startEvent = (ProcessingTrackEvent)trackerInfo;
                    entries.add(taskInfos);
                }
                if (trackerInfo instanceof ProcessingFinishedTrackEvent && entries.size() > 0) {
                    taskInfos = null;
                    int iToken = entries.size() - 1;
                    while (iToken >= 0) {
                        UITaskTrackInfo ts = entries.get(iToken);
                        if (ts.files.equals(((ProcessingFinishedTrackEvent)trackerInfo).getFiles())) {
                            taskInfos = ts;
                            break;
                        }
                        --iToken;
                    }
                    if (taskInfos != null) {
                        taskInfos.status = ((TrackerInfoEntry)trackerInfo).getEventtype() == Tracking.TrackEventType.Processed ? "Finished" : "Failed";
                        taskInfos.finishTime = trackerInfo.getTime();
                    }
                }
            } else if (trackerInfo instanceof TrackInfo && i != 0) {
                taskInfos = new UITaskTrackInfo();
                entries.add(taskInfos);
                taskInfos.files = trackerInfo.getTaskName();
                taskInfos.status = ((TrackInfo)trackerInfo).getExecStatus().toString();
                taskInfos.startTime = trackerInfo.getTime();
                taskInfos.finishTime = ((TrackInfo)trackerInfo).getFinishTime();
                taskInfos.mainTask = true;
            }
            ++i;
        }
        return entries;
    }
}

