/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

public class Publication {
    String DOI;
    String pubmed;
    String title;
    String url;
    int year;
    String journal = "";
    String authers;
    String volume;
    String issue;
    String pages;
    static final String DOI_PREFIX = "doi:";

    public String getPages() {
        return this.pages;
    }

    public Publication setPages(String pages) {
        this.pages = pages;
        return this;
    }

    public String getVolume() {
        return this.volume;
    }

    public Publication setVolume(String volume) {
        this.volume = volume;
        return this;
    }

    public Publication setVolume(int v) {
        this.volume = "" + v;
        return this;
    }

    public String getIssue() {
        return this.issue;
    }

    public Publication setIssue(String issue) {
        this.issue = issue;
        return this;
    }

    public Publication setIssue(int issue) {
        this.issue = "" + issue;
        return this;
    }

    public String getAuthers() {
        return this.authers;
    }

    public Publication setAuthors(String authers) {
        this.authers = authers;
        return this;
    }

    public int getYear() {
        return this.year;
    }

    public Publication setYear(int year) {
        this.year = year;
        return this;
    }

    public String getJournal() {
        return this.journal;
    }

    public Publication setJournal(String journal) {
        this.journal = journal;
        return this;
    }

    public String getDOI() {
        return this.getDOI(false);
    }

    public String getDOI(boolean removeDOIPrefix) {
        if (this.DOI != null && removeDOIPrefix && this.DOI.startsWith(DOI_PREFIX)) {
            return this.DOI.substring(DOI_PREFIX.length());
        }
        if (this.DOI != null && !removeDOIPrefix && !this.DOI.startsWith(DOI_PREFIX)) {
            return DOI_PREFIX + this.DOI;
        }
        return this.DOI;
    }

    public Publication setDOI(String doi) {
        this.DOI = doi;
        return this;
    }

    public String getPubmed() {
        return this.pubmed;
    }

    public Publication setPubmed(String pubmed) {
        this.pubmed = pubmed;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Publication setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Publication setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getCitation() {
        String cite = "";
        if (this.authers != null) {
            cite = this.year == 0 ? String.format("%s. \"%s.\" %s", this.authers, this.title, this.journal) : String.format("%s, %d. \"%s.\" %s", this.authers, this.year, this.title, this.journal);
            if (this.volume != null) {
                cite = String.format("%s, %s", cite, this.volume);
                if (this.issue != null) {
                    cite = String.format("%s(%s)", cite, this.volume);
                }
            }
            if (this.pages != null) {
                cite = String.format("%s, %s", cite, this.pages);
            }
        } else {
            return this.title.trim();
        }
        cite = String.format("%s.", cite);
        return cite.trim();
    }

    public String getFormatedStr() {
        String ref = this.getDOI() != null ? String.format("- %1$s. <a href=\"http://doi.org/%2$s\">doi:%2$s.</a>", this.getCitation(), this.getDOI(true)) : (this.getUrl() != null ? String.format("<a href=\"%s\">- %s</a>", this.getUrl(), this.getCitation()) : this.getCitation());
        return ref;
    }
}

